/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.unitarou.ml.Message;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.Situation;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.gm.HandlerStatusActions;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeStatusPanel
implements Adaptable,
WidgetContainer {
    private static final Message LB_SITUATION_DRAW = new Message(NodeStatusPanel.class, "lbSituationDraw");
    private static final Message LB_SITUATION_WHITE = new Message(NodeStatusPanel.class, "lbSituationWhite");
    private static final Message LB_SITUATION_BLACK = new Message(NodeStatusPanel.class, "lbSituationBlack");
    private Composite composite_ = null;
    private ToolBarManager toolBarManager_ = null;
    private Label statusLabel_ = null;
    private Label whiteCaptured_ = null;
    private Label blackCaptured_ = null;
    private final HandlerStatusActions handlerStatusActions_ = new HandlerStatusActions();
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.composite_ = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        this.composite_.setLayout(gridLayout);
        this.toolBarManager_ = new ToolBarManager(0x800000);
        ToolBar toolBar = this.toolBarManager_.createControl(this.composite_);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        toolBar.setLayoutData(gridData);
        this.createStatusArea(this.composite_);
        this.createCapturedArea(this.composite_);
        return this.composite_;
    }

    private void createStatusArea(Composite composite) {
        this.statusLabel_ = new Label(composite, 131072);
        GridData gridData = new GridData(131072, 0x1000000, true, false);
        this.statusLabel_.setLayoutData(gridData);
    }

    private void createCapturedArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false);
        composite2.setLayoutData(gridData);
        composite2.setLayout(new RowLayout());
        Label label = new Label(composite2, 16384);
        label.setImage(NodeImage.WHITE.get());
        this.whiteCaptured_ = new Label(composite2, 16384);
        label = new Label(composite2, 16384);
        label.setImage(NodeImage.BLACK.get());
        this.blackCaptured_ = new Label(composite2, 16384);
    }

    public Control getControl() {
        return this.composite_;
    }

    @Override
    public void dispose() {
    }

    private void updateToolBar() {
        this.toolBarManager_.removeAll();
        Action[] actionArray = this.handlerStatusActions_.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            this.toolBarManager_.add(actionArray[i]);
        }
        if (actionArray.length != 0) {
            actionArray[0].setEnabled(true);
            actionArray[0].setChecked(true);
        }
        this.toolBarManager_.update(false);
        this.toolBarManager_.getControl().getParent().layout();
    }

    private class Adapter
    implements CollectionMonitor,
    GameInfoNodeMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    ModelEventNotifier {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        private Reference<NodeView> refNodeView = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void update(CollectionEditor collectionEditor) {
            NodeStatusPanel.this.updateToolBar();
        }

        public void currentChanged(NodeView nodeView) {
            String string;
            ArgumentChecker.throwIfNull((Object)nodeView);
            this.refNodeView = new WeakReference<NodeView>(nodeView);
            boolean bl = false;
            String string2 = String.valueOf(nodeView.getCaptured(SgfColor.WHITE).size());
            if (!string2.equals(NodeStatusPanel.this.whiteCaptured_.getText())) {
                NodeStatusPanel.this.whiteCaptured_.setText(string2);
                bl = true;
            }
            if (!(string = String.valueOf(nodeView.getCaptured(SgfColor.BLACK).size())).equals(NodeStatusPanel.this.blackCaptured_.getText())) {
                NodeStatusPanel.this.blackCaptured_.setText(string);
                bl = true;
            }
            if (bl |= this.updateStatusLabel(nodeView)) {
                NodeStatusPanel.this.composite_.layout();
            }
        }

        public void gameInfoChanged(NodeView nodeView) {
            if (nodeView.getProperty(SgfId.KOMI) == null) {
                return;
            }
            NodeView nodeView2 = this.refNodeView.get();
            if (nodeView2 == null) {
                return;
            }
            if (this.updateStatusLabel(nodeView2)) {
                NodeStatusPanel.this.composite_.layout();
            }
        }

        private boolean updateStatusLabel(NodeView nodeView) {
            Situation situation = nodeView.getSituation();
            if (situation.isEmpty()) {
                String string = NodeStatusPanel.this.statusLabel_.getText();
                if (string.length() != 0) {
                    NodeStatusPanel.this.statusLabel_.setText("");
                    return true;
                }
                return false;
            }
            Object[] objectArray = new Object[]{new Double(situation.score()), new Integer(situation.getBlackTerritory() + situation.getBlackCaptured()), new Integer(situation.getWhiteTerritory() + situation.getWhiteCaptured()), new Double(situation.getKomi())};
            SgfColor sgfColor = situation.winner();
            if (sgfColor == SgfColor.WHITE) {
                NodeStatusPanel.this.statusLabel_.setText(LB_SITUATION_WHITE.get(objectArray));
            } else if (sgfColor == SgfColor.BLACK) {
                NodeStatusPanel.this.statusLabel_.setText(LB_SITUATION_BLACK.get(objectArray));
            } else {
                NodeStatusPanel.this.statusLabel_.setText(LB_SITUATION_DRAW.get(objectArray));
            }
            return true;
        }

        public void setEditMode(boolean bl) {
            NodeStatusPanel.this.updateToolBar();
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(NodeStatusPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(NodeStatusPanel.this);
            NodeStatusPanel.this.handlerStatusActions_.setEventBroker(this.eventBroker_);
            NodeStatusPanel.this.updateToolBar();
        }
    }
}

