/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter;

public class SimpleStonePainter
extends AbstractStonePainter {
    private static final Message LB_DISPLAY_NAME = new Message(SimpleStonePainter.class, "lbDisplayName");
    private static final ColorResource COLOR_WHITE_BODY = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_WHITE_BORDER = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_WHITE_NUMBER = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_BLACK_BODY = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_BLACK_BORDER = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_BLACK_NUMBER = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_LAST_NUMBER = new ColorResource(255, 0, 0);
    private static final ColorResource COLOR_LAST = new ColorResource(204, 0, 0);
    private static final FontResource FONT_MOVE_NUMBER = new FontResource("Helvetica", 10, 1);

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    protected ImageData createWhiteStone(Point point) {
        return this.createStoneImage(point, COLOR_WHITE_BODY.get(), COLOR_WHITE_BORDER.get());
    }

    protected ImageData createBlackStone(Point point) {
        return this.createStoneImage(point, COLOR_BLACK_BODY.get(), COLOR_BLACK_BORDER.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createStoneImage(Point point, Color color, Color color2) {
        ImageData imageData;
        Image image = null;
        GC gC = null;
        try {
            image = new Image(null, point.x, point.y);
            gC = new GC(image);
            gC.setBackground(COLOR_TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setBackground(color);
            gC.fillOval(0, 0, point.x, point.y);
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            gC.setForeground(color2);
            gC.drawOval(0, 0, point.x - 1, point.y - 1);
            ImageData imageData2 = image.getImageData();
            imageData2.transparentPixel = imageData2.getPixel(0, 0);
            imageData = imageData2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
        Swts.disposeQuietly(image);
        return imageData;
    }

    protected void paintLabel(GC gC, Rectangle rectangle, String string, SgfColor sgfColor, boolean bl) {
        gC.setFont(FONT_MOVE_NUMBER.getInCircle(gC, string, rectangle.width));
        Point point = gC.textExtent(string);
        Color color = bl ? COLOR_LAST_NUMBER.get() : (SgfColor.BLACK.equals(sgfColor) ? COLOR_BLACK_NUMBER.get() : COLOR_WHITE_NUMBER.get());
        gC.setForeground(color);
        gC.drawText(string, rectangle.x + rectangle.width / 2 - point.x / 2, rectangle.y + rectangle.height / 2 - point.y / 2, true);
    }

    protected void paintLastMoveMark(GC gC, Rectangle rectangle, SgfColor sgfColor) {
        gC.setLineWidth(2);
        gC.setLineStyle(1);
        gC.setBackground(COLOR_LAST.get());
        Rectangle rectangle2 = Rectangles.createScaled(rectangle, 0.4);
        gC.fillOval(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }
}

