/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;
import org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter;

class CirclePainter
extends AbstractPainter {
    private static final ColorResource BODY = new ColorResource(0, 153, 0);
    private static final ColorResource BORDER = new ColorResource(0, 102, 0);
    private static final ColorResource TRANSPARENT = new ColorResource(0, 255, 0);
    private static double sizeRatio_s_ = 0.5;

    public static void setSizeRatio(double d) {
        sizeRatio_s_ = d;
    }

    public static double getSizeRatio() {
        return sizeRatio_s_;
    }

    CirclePainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageData createImageData() {
        Image image = null;
        GC gC = null;
        try {
            Point point = this.getSize();
            image = new Image(null, point.x, point.y);
            gC = new GC(image);
            Rectangle rectangle = Geometry.createRectangle(new Point(0, 0), point);
            rectangle = Rectangles.createScaled(rectangle, sizeRatio_s_);
            gC.setBackground(TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setBackground(BODY.get());
            gC.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            gC.setForeground(BORDER.get());
            gC.drawOval(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.getPixel(0, 0);
            ImageData imageData2 = imageData;
            return imageData2;
        }
        finally {
            if (gC != null) {
                gC.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

