/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyEvent;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.PropertyType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.LineEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.MarkupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SelectEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SetupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.HandlerPhaseVer1;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.MoveEventDelegatorVer1;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.VariationEventDelegatorVer1;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorStateHandlerVer1
extends CanvasHookedStateHandler {
    private static final Log log_s_ = LogFactory.getLog(EditorStateHandlerVer1.class);
    private int lastKeyCode_;
    private final Adapter adapter_;

    public EditorStateHandlerVer1(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        this.registerDelegator(HandlerPhase.SELECT, new SelectEventDelegator());
        this.registerDelegator(HandlerPhaseVer1.MOVE, new MoveEventDelegatorVer1());
        this.registerDelegator(HandlerPhaseVer1.VARIATION, new VariationEventDelegatorVer1());
        this.registerDelegator(HandlerPhase.SETUP, new SetupEventDelegator());
        this.registerDelegator(HandlerPhase.MARKUP, new MarkupEventDelegator());
        this.registerDelegator(HandlerPhase.LINE, new LineEventDelegator());
        this.setEventDelegator(HandlerPhase.SELECT);
        this.lastKeyCode_ = 0;
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    protected void keyPressed(KeyEvent keyEvent) {
        this.updateKey(keyEvent.keyCode | keyEvent.stateMask);
        super.keyPressed(keyEvent);
    }

    @Override
    protected void keyReleased(KeyEvent keyEvent) {
        this.updateKey(keyEvent.keyCode ^ keyEvent.stateMask);
        super.keyReleased(keyEvent);
    }

    protected void updateKey(int n) {
        if (this.lastKeyCode_ == n) {
            return;
        }
        EventBroker eventBroker = this.getEventBroker();
        this.lastKeyCode_ = n;
        EventDelegator eventDelegator = this.getEventDelegator();
        if (MarkupEventDelegator.class.equals(eventDelegator.getClass())) {
            switch (n) {
                case 65636: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
                }
            }
        } else if (LineEventDelegator.class.equals(eventDelegator.getClass())) {
            switch (n) {
                case 65651: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
                }
            }
        } else if (SetupEventDelegator.class.equals(eventDelegator.getClass())) {
            switch (n) {
                case 65651: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
                }
            }
        } else {
            switch (n) {
                case 131072: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
                    break;
                }
                case 393216: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.VARIATION));
                    break;
                }
                case 65651: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
                    break;
                }
                case 65636: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.MARKUP));
                    break;
                }
                case 65644: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.LINE));
                    break;
                }
            }
        }
        this.changeVariation(n);
        BlockSituation blockSituation = eventDelegator.getBlockSituation(this.getIgoBoardPanel().getNodeView(), this.getBlockStatus(), this.getMouseEvent());
        this.getIgoBoardPanel().getCanvas().setCursor(blockSituation.getCursor());
        this.getIgoBoardPanel().paintInTransient(blockSituation.getTransientProperty());
    }

    @Override
    protected void mouseWheel(int n) {
        if ((n /= 3) != 0) {
            NodeJumpCommand nodeJumpCommand = new NodeJumpCommand(n);
            this.getEventBroker().executeCommand(nodeJumpCommand);
        }
    }

    private class Adapter
    implements ControllerStatusMonitor,
    NodeMonitor {
        private HandlerPhase currentHandlerPhase_;

        private Adapter() {
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(this.currentHandlerPhase_)) {
                return;
            }
            if (EditorStateHandlerVer1.this.findDelegator(handlerPhase) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SELECT + " insted. status=" + handlerPhase);
                handlerPhase = HandlerPhase.SELECT;
            }
            EditorStateHandlerVer1.this.setEventDelegator(handlerPhase);
            EditorStateHandlerVer1.this.getEventDelegator().resetStatus();
            BlockSituation blockSituation = EditorStateHandlerVer1.this.getEventDelegator().getBlockSituation(EditorStateHandlerVer1.this.getIgoBoardPanel().getNodeView(), EditorStateHandlerVer1.this.getBlockStatus(), EditorStateHandlerVer1.this.getMouseEvent());
            EditorStateHandlerVer1.this.getIgoBoardPanel().getCanvas().setCursor(blockSituation.getCursor());
            this.currentHandlerPhase_ = handlerPhase;
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (HandlerPhase.SELECT.equals(this.currentHandlerPhase_)) {
                return;
            }
            EventBroker eventBroker = EditorStateHandlerVer1.this.getEventBroker();
            HandlerPhase handlerPhase = this.currentHandlerPhase_;
            if (HandlerPhase.LINE.equals(this.currentHandlerPhase_)) {
                handlerPhase = this.currentHandlerPhase_;
            } else if (HandlerPhase.MARKUP.equals(this.currentHandlerPhase_)) {
                handlerPhase = this.currentHandlerPhase_;
            } else if (nodeView.containsPropertyType(PropertyType.SETUP)) {
                handlerPhase = HandlerPhase.SETUP;
            } else if (nodeView.containsPropertyType(PropertyType.MOVE) && nodeView.isLast()) {
                handlerPhase = HandlerPhaseVer1.MOVE;
            } else if (nodeView.containsPropertyType(PropertyType.MOVE) && !nodeView.isLast()) {
                handlerPhase = HandlerPhaseVer1.VARIATION;
            }
            if (!Objects.equalsIncludeNull(handlerPhase, this.currentHandlerPhase_)) {
                this.changeHandlerPhase(handlerPhase);
                eventBroker.executeCommand(new ChangeHandlerPhaseCommand(handlerPhase));
            }
        }
    }
}

