/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;

public class SelectEventDelegator
implements EventDelegator {
    public void resetStatus() {
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation blockSituation = new BlockSituation();
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        switch (mouseEvent.button) {
            case 3: {
                eventBroker.executeCommand(new NodeJumpCommand(-1));
                return true;
            }
            case 1: {
                int n = this.findVariationIndex(nodeView, blockStatus.getPoint());
                if (n == -1) {
                    eventBroker.executeCommand(new NodeJumpCommand(1));
                    return true;
                }
                eventBroker.executeCommand(new SelectVariation(n, true));
                if (nodeView.isChildrenStyle()) {
                    eventBroker.executeCommand(new NodeJumpCommand(1));
                }
                return true;
            }
        }
        return false;
    }

    private int findVariationIndex(NodeView nodeView, SgfPoint sgfPoint) {
        int n;
        int n2 = nodeView.getSelectedVariationIndex();
        if (n2 == -1) {
            return -1;
        }
        NodeView[] nodeViewArray = nodeView.getVariations();
        for (n = n2 + 1; n < nodeViewArray.length; ++n) {
            if (!this.isMatchMove(sgfPoint, nodeViewArray[n].getMove().getPoint())) continue;
            return n;
        }
        for (n = 0; n <= n2; ++n) {
            if (!this.isMatchMove(sgfPoint, nodeViewArray[n].getMove().getPoint())) continue;
            return n;
        }
        return -1;
    }

    private boolean isMatchMove(SgfPoint sgfPoint, SgfPoint sgfPoint2) {
        return Objects.equalsIncludeNull(sgfPoint, sgfPoint2) || sgfPoint == null && sgfPoint2.condition().equals((Object)SgfPointType.PASS);
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }
}

