/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.BlockedBoardDesigner;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.CoordinatesPainter;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.MarkPainter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleCoordinatesPainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.SimpleMarkerPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgoGraphicalBoardPanel
implements IgoBoardPanel {
    private static final Log log_s_ = LogFactory.getLog(IgoGraphicalBoardPanel.class);
    private static final int MINIMUM_BLOCK_SIZE = 2;
    private static final ColorResource FOREGROUND_CANT_PAINT = new ColorResource(255, 0, 0);
    private static final SgfId[] IDS_STONE = new SgfId[]{SgfId.WHITE, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY};
    private Canvas canvas_ = null;
    private SgfRectangle view_ = new SgfRectangle();
    private BoardPainter boardPainter_ = new SimpleBoardPainter();
    private RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private CoordinatesPainter coordinatesPainter_ = new SimpleCoordinatesPainter();
    private StonePainter stonePainter_ = StonePainter.CONTEXT.defaultProvider();
    private MarkPainter markPainter_ = new SimpleMarkerPainter();
    private int blockSize_;
    private Point labelSize_ = new Point(1, 1);
    private Point offsetSize_ = new Point(0, 0);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeView nodeView_;
    private final BlockedBoardDesigner blockedBoardDesigner_ = new BlockedBoardDesigner(new IgoBoard(SgfSize.DEFAULT));
    private CurrentContext context_;
    private final HashMap<SgfPoint, BlockStatus> blockStatusMap_ = new HashMap();
    private boolean usesDoubleBuffer_ = true;
    private Property transientProperty_ = null;
    private Adapter adapter_ = new Adapter();
    private BlockLabelProvider blockLabelProvider_ = BlockLabelProvider.CONTEXT.defaultProvider();
    private VariationLabelProvider variationLabelProvider_ = VariationLabelProvider.CONTEXT.defaultProvider();
    private boolean showLastMoveMark_ = true;

    public IgoGraphicalBoardPanel() {
        this.context_ = CurrentContext.nullContext;
        this.blockedBoardDesigner_.addBlockPainter(this.boardPainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.ruledLinePainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.stonePainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.markPainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.blockLabelProvider_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.canvas_ = new Canvas(composite, 262144);
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = new Rectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                if (IgoGraphicalBoardPanel.this.usesDoubleBuffer_) {
                    IgoGraphicalBoardPanel.this.paintByDoubleBuffer(paintEvent.gc, rectangle);
                } else {
                    IgoGraphicalBoardPanel.this.paint(paintEvent.gc, rectangle);
                }
            }
        });
        this.canvas_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                IgoGraphicalBoardPanel.this.blockStatusMap_.clear();
            }
        });
        return this.canvas_;
    }

    @Override
    public void dispose() {
        this.canvas_.dispose();
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.nodeView_ = null;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintByDoubleBuffer(GC gC, Rectangle rectangle) {
        Image image = null;
        GC gC2 = null;
        try {
            image = new Image((Device)this.canvas_.getDisplay(), this.canvas_.getBounds());
            gC2 = new GC(image);
            this.paint(gC2, rectangle);
            gC.drawImage(image, 0, 0);
        }
        finally {
            if (gC2 != null) {
                gC2.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    private void paint(GC gC, Rectangle rectangle) {
        if (this.nodeView_ == null) {
            log_s_.info("Call paint(GC gc, Rectangle paintArea) before init model.");
            return;
        }
        SgfSize sgfSize = this.nodeView_.getSize();
        this.view_ = this.blockedBoardDesigner_.calcView();
        this.calcDrawParameters();
        if (this.blockSize_ < 2) {
            this.paintCantDraw(gC);
            return;
        }
        Rectangle rectangle2 = this.calcDrawArea(this.view_);
        this.paintBackground(gC, rectangle2);
        this.coordinatesPainter_.paint(gC, rectangle2, this.view_, new boolean[]{true, true, false, false});
        for (int i = this.view_.getStart().y(); i <= this.view_.getEnd().y(); ++i) {
            for (int j = this.view_.getStart().x(); j <= this.view_.getEnd().x(); ++j) {
                SgfPoint sgfPoint = SgfPoint.create(sgfSize, j, i);
                if (this.blockedBoardDesigner_.isDrawArea(sgfPoint)) {
                    this.paintImpl(gC, rectangle, sgfPoint);
                    continue;
                }
                this.paintBackground(gC, sgfPoint);
            }
        }
        this.paintLabel(gC);
        this.paintLine(gC);
        this.paintVariation(gC);
        this.paintTransientStone(gC, rectangle2);
        this.paintTransientMarkers(gC);
    }

    private void paintCantDraw(GC gC) {
        Point point = this.canvas_.getSize();
        int n = Math.min(point.x, point.y);
        gC.setForeground(FOREGROUND_CANT_PAINT.get());
        gC.setBackground(Display.getCurrent().getSystemColor(22));
        gC.fillRectangle(0, 0, point.x, point.y);
        gC.drawRectangle(0, 0, n - 1, n - 1);
        gC.drawLine(0, 0, n, n);
        gC.drawLine(0, n, n, 0);
    }

    private void paintBackground(GC gC, Rectangle rectangle) {
        gC.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        Rectangle rectangle2 = this.canvas_.getBounds();
        gC.fillRectangle(0, 0, rectangle.x, rectangle2.height);
        gC.fillRectangle(rectangle.x, 0, rectangle2.width, rectangle.y);
        gC.fillRectangle(rectangle.x + rectangle.width, rectangle.y, rectangle2.width, rectangle2.height);
        gC.fillRectangle(rectangle.x, rectangle.y + rectangle.height, rectangle2.width, rectangle2.height);
    }

    private void paintBackground(GC gC, SgfPoint sgfPoint) {
        gC.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        Rectangle rectangle = this.calcBlockArea(sgfPoint);
        ++rectangle.width;
        ++rectangle.height;
        gC.fillRectangle(rectangle);
    }

    private void paintImpl(GC gC, Rectangle rectangle, SgfPoint sgfPoint) {
        Rectangle rectangle2 = this.calcBlockArea(sgfPoint);
        if (rectangle2.x + rectangle2.width < rectangle.x || rectangle.x + rectangle.width < rectangle2.x || rectangle2.y + rectangle2.height < rectangle.y || rectangle.y + rectangle.height < rectangle2.y) {
            return;
        }
        this.boardPainter_.paint(gC, sgfPoint, rectangle2);
        this.ruledLinePainter_.paint(gC, sgfPoint, rectangle2);
        this.paintStone(gC, sgfPoint, rectangle2);
        this.paintMarks(gC, sgfPoint, rectangle2);
        this.paintStatus(gC, this.blockStatusMap_.get(sgfPoint));
    }

    private void calcDrawParameters() {
        Rectangle rectangle = this.canvas_.getBounds();
        this.labelSize_ = this.coordinatesPainter_.calcLabelSize(this.view_);
        this.blockSize_ = Math.min((rectangle.width - this.labelSize_.x) / this.view_.width(), (rectangle.height - this.labelSize_.y) / this.view_.height());
        this.blockSize_ = Math.min(this.blockSize_, this.context_.getInteger(Context.MAX_STONE_SIZE));
        this.offsetSize_.x = (rectangle.width - (this.blockSize_ * this.view_.width() + this.labelSize_.x)) / 2;
        this.offsetSize_.y = (rectangle.height - (this.blockSize_ * this.view_.height() + this.labelSize_.y)) / 2;
    }

    private Rectangle calcBlockArea(SgfPoint sgfPoint) {
        return new Rectangle(this.labelSize_.x + (sgfPoint.x() - this.view_.getStart().x()) * this.blockSize_ + this.offsetSize_.x, this.labelSize_.y + (sgfPoint.y() - this.view_.getStart().y()) * this.blockSize_ + this.offsetSize_.y, this.blockSize_, this.blockSize_);
    }

    private Rectangle calcDrawArea(SgfRectangle sgfRectangle) {
        return new Rectangle(this.labelSize_.x + (sgfRectangle.getStart().x() - this.view_.getStart().x()) * this.blockSize_ + this.offsetSize_.x, this.labelSize_.y + (sgfRectangle.getStart().y() - this.view_.getStart().y()) * this.blockSize_ + this.offsetSize_.y, sgfRectangle.width() * this.blockSize_, sgfRectangle.height() * this.blockSize_);
    }

    private void paintStone(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        StonePainterParameter stonePainterParameter;
        EnumSet<SgfPointType> enumSet = this.getBlockStatusImpl(sgfPoint).getPointTypes();
        if (enumSet.contains((Object)SgfPointType.WHITE)) {
            stonePainterParameter = new StonePainterParameter();
            stonePainterParameter.setSgfColor(SgfColor.WHITE);
        } else if (enumSet.contains((Object)SgfPointType.BLACK)) {
            stonePainterParameter = new StonePainterParameter();
            stonePainterParameter.setSgfColor(SgfColor.BLACK);
        } else {
            return;
        }
        if (this.transientProperty_ != null) {
            for (SgfId sgfId : IDS_STONE) {
                if (!this.transientProperty_.contains(sgfId, sgfPoint.getString())) continue;
                stonePainterParameter.setTransient(true);
                break;
            }
        }
        Stone stone = this.nodeView_.getMove();
        String string = this.blockLabelProvider_.getLabel(this.nodeView_, sgfPoint);
        stonePainterParameter.setLastMove(this.showLastMoveMark_ && sgfPoint.equals(stone.getPoint()));
        stonePainterParameter.setLabel(string);
        this.stonePainter_.paintStone(gC, rectangle, stonePainterParameter);
    }

    private void paintMarks(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        for (SgfId sgfId : this.blockedBoardDesigner_.getMarkers(sgfPoint)) {
            if (this.transientProperty_ != null && this.transientProperty_.contains(sgfId, sgfPoint.getString())) break;
            this.markPainter_.paintMark(gC, rectangle, sgfId, false);
        }
    }

    private void paintStatus(GC gC, BlockStatus blockStatus) {
        this.markPainter_.paintStatus(gC, blockStatus);
    }

    private void paintTransientStone(GC gC, Rectangle rectangle) {
        if (this.transientProperty_ == null) {
            return;
        }
        SgfColor sgfColor = SgfColor.getStoneColor(this.transientProperty_.sgfId());
        if (sgfColor == null) {
            return;
        }
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        stonePainterParameter.setLabel(null);
        stonePainterParameter.setLastMove(false);
        stonePainterParameter.setTransient(true);
        stonePainterParameter.setSgfColor(sgfColor);
        for (String string : this.transientProperty_.getStrings()) {
            Rectangle rectangle2;
            SgfPoint sgfPoint = SgfPoint.parseMoveQuietly(this.nodeView_.getSize(), string);
            if (sgfPoint == null || 0 != Geometry.getRelativePosition(rectangle, Geometry.centerPoint(rectangle2 = this.calcBlockArea(sgfPoint)))) continue;
            this.stonePainter_.paintStone(gC, rectangle2, stonePainterParameter);
        }
    }

    private void paintTransientMarkers(GC gC) {
        if (this.transientProperty_ == null) {
            return;
        }
        SgfId[] sgfIdArray = this.markPainter_.markerScope();
        for (int i = 0; i < sgfIdArray.length; ++i) {
            if (!sgfIdArray[i].equals(this.transientProperty_.sgfId())) continue;
            for (String string : this.transientProperty_.getStrings()) {
                SgfPoint sgfPoint = SgfPoint.parseMoveQuietly(this.nodeView_.getSize(), string);
                if (sgfPoint == null) continue;
                Rectangle rectangle = this.calcBlockArea(sgfPoint);
                this.markPainter_.paintMark(gC, rectangle, sgfIdArray[i], true);
            }
        }
    }

    private void paintLabel(GC gC) {
        Rectangle rectangle;
        Label[] labelArray = this.blockedBoardDesigner_.getLabels();
        for (int i = 0; i < labelArray.length; ++i) {
            rectangle = this.calcBlockArea(labelArray[i].getPoint());
            this.markPainter_.paintLabel(gC, rectangle, labelArray[i], false);
        }
        if (this.transientProperty_ == null || !this.transientProperty_.sgfId().equals(SgfId.LABEL)) {
            return;
        }
        Label label = Label.parseQuietly(this.nodeView_.getSize(), this.transientProperty_.getStrings()[0]);
        rectangle = this.calcBlockArea(label.getPoint());
        this.markPainter_.paintLabel(gC, rectangle, label, true);
    }

    private void paintLine(GC gC) {
        for (SgfId sgfId : new SgfId[]{SgfId.LINE, SgfId.ARROW}) {
            String string = "";
            if (this.transientProperty_ != null && sgfId.equals(this.transientProperty_.sgfId())) {
                string = this.transientProperty_.getStrings()[0];
            }
            this.paintLineImpl(gC, sgfId, string);
        }
    }

    private void paintLineImpl(GC gC, SgfId sgfId, String string) {
        Rectangle rectangle;
        for (SgfLine object : this.blockedBoardDesigner_.getLine(sgfId)) {
            rectangle = this.calcBlockArea(object.getStart());
            Rectangle rectangle2 = this.calcBlockArea(object.getEnd());
            this.markPainter_.paintLine(gC, rectangle, rectangle2, sgfId, object.getString().equals(string));
        }
        if (this.transientProperty_ == null || !sgfId.equals(this.transientProperty_.sgfId())) {
            return;
        }
        Object[] objectArray = this.transientProperty_.getStrings();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                SgfLine sgfLine = SgfLine.parse(this.nodeView_.getSize(), (String)objectArray[i]);
                Rectangle rectangle3 = this.calcBlockArea(sgfLine.getStart());
                rectangle = this.calcBlockArea(sgfLine.getEnd());
                this.markPainter_.paintLine(gC, rectangle3, rectangle, sgfId, true);
                continue;
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
    }

    private void paintVariation(GC gC) {
        List<String> list;
        NodeView[] nodeViewArray = this.nodeView_.getVariations();
        if (nodeViewArray.length == 0) {
            return;
        }
        HashMap<SgfPoint, ArrayList<String>> hashMap = new HashMap<SgfPoint, ArrayList<String>>(nodeViewArray.length);
        for (int i = 0; i < nodeViewArray.length; ++i) {
            SgfPoint object;
            if (!this.nodeView_.isChildrenStyle() && i == this.nodeView_.getSelectedVariationIndex() || (object = nodeViewArray[i].getMove().getPoint()) == null || SgfPointType.PASS.equals((Object)object.condition())) continue;
            list = (List)hashMap.get(object);
            if (list == null) {
                list = new ArrayList<String>(nodeViewArray.length);
                hashMap.put(object, (ArrayList<String>)list);
            }
            list.add(this.variationLabelProvider_.getVariationLabel(i));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            list = this.calcBlockArea((SgfPoint)entry.getKey());
            List list2 = (List)entry.getValue();
            String[] stringArray = list2.toArray(new String[list2.size()]);
            this.markPainter_.paintVariation(gC, (Rectangle)((Object)list), stringArray);
        }
    }

    private void redraw() {
        SgfRectangle sgfRectangle = this.view_;
        this.view_ = this.blockedBoardDesigner_.calcView();
        if (!sgfRectangle.equals(this.view_)) {
            this.refresh();
            return;
        }
        this.calcDrawParameters();
        Set<SgfPoint> set = this.blockedBoardDesigner_.getRedrawBlocks();
        SgfRectangle sgfRectangle2 = SgfRectangle.create(set);
        sgfRectangle2.union(this.view_);
        Rectangle rectangle = this.calcDrawArea(sgfRectangle2);
        this.canvas_.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        if (log_s_.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Redraw rectangle is: ").append(rectangle).append('[').append(sgfRectangle2.getStart().x() - this.view_.getStart().x() + 1).append(",").append(sgfRectangle2.getStart().y() - this.view_.getStart().y() + 1).append("]-[").append(sgfRectangle2.getStart().x() - this.view_.getStart().x() + sgfRectangle2.width()).append(",").append(sgfRectangle2.getStart().y() - this.view_.getStart().y() + sgfRectangle2.height()).append("]");
            log_s_.trace(stringBuilder);
        }
    }

    private void refresh() {
        this.canvas_.redraw(0, 0, this.canvas_.getBounds().width, this.canvas_.getBounds().height, false);
        log_s_.trace("Refreshed.");
    }

    public boolean isUsesDoubleBuffer() {
        return this.usesDoubleBuffer_;
    }

    public void setUsesDoubleBuffer(boolean bl) {
        this.usesDoubleBuffer_ = bl;
    }

    @Override
    public void paintInTransient(Property property) {
        boolean bl;
        if (property != null) {
            bl = !property.equals(this.transientProperty_);
        } else {
            boolean bl2 = bl = property != this.transientProperty_;
        }
        if (!bl) {
            this.transientProperty_ = property;
        } else {
            this.addRedrawPoint(property);
            this.addRedrawPoint(this.transientProperty_);
            this.transientProperty_ = property;
            this.redraw();
        }
    }

    private void addRedrawPoint(Property property) {
        if (property == null) {
            return;
        }
        if (this.addDdRedrawPoint(property)) {
            return;
        }
        switch (property.sgfId().valueType()) {
            case CPOINT: 
            case POINT: 
            case MOVE: {
                SgfPoint[] sgfPointArray = SgfPoint.parse(this.nodeView_.getSize(), property.getStrings());
                for (int i = 0; i < sgfPointArray.length; ++i) {
                    this.blockedBoardDesigner_.addRedrawPoint(sgfPointArray[i]);
                }
                break;
            }
        }
    }

    private boolean addDdRedrawPoint(Property property) {
        if (!SgfId.DIM_POINTS.equals(property.sgfId())) {
            return false;
        }
        SgfPoint[] sgfPointArray = SgfPoint.parse(this.nodeView_.getSize(), property.getStrings());
        if (sgfPointArray.length != 1 || !sgfPointArray[0].condition().equals((Object)SgfPointType.PASS)) {
            for (int i = 0; i < sgfPointArray.length; ++i) {
                this.blockedBoardDesigner_.addRedrawPoint(sgfPointArray[i]);
            }
            return true;
        }
        for (int i = this.view_.getStart().x(); i < this.view_.getEnd().x(); ++i) {
            for (int j = this.view_.getStart().y(); j < this.view_.getEnd().y(); ++j) {
                this.blockedBoardDesigner_.addRedrawPoint(SgfPoint.create(sgfPointArray[0].size(), i, j));
            }
        }
        return true;
    }

    @Override
    public NodeView getNodeView() {
        return this.nodeView_;
    }

    @Override
    public BlockStatus getBlockStatus(Point point) {
        ArgumentChecker.throwIfNull((Object)point);
        int n = (int)Math.floor((double)(point.x - this.labelSize_.x - this.offsetSize_.x) / (double)this.blockSize_) + this.view_.getStart().x();
        int n2 = (int)Math.floor((double)(point.y - this.labelSize_.y - this.offsetSize_.y) / (double)this.blockSize_) + this.view_.getStart().y();
        SgfSize sgfSize = this.nodeView_.getSize();
        if (!sgfSize.check(n, n2).equals((Object)SgfPointType.IN)) {
            return this.getBlockStatusImpl(null);
        }
        SgfPoint sgfPoint = SgfPoint.create(sgfSize, n, n2);
        if (!this.blockedBoardDesigner_.isDrawArea(sgfPoint)) {
            return this.getBlockStatusImpl(null);
        }
        return this.getBlockStatusImpl(sgfPoint);
    }

    private BlockStatus getBlockStatusImpl(SgfPoint sgfPoint) {
        BlockStatus blockStatus = this.blockStatusMap_.get(sgfPoint);
        if (blockStatus != null) {
            return blockStatus;
        }
        blockStatus = this.createBlockStatus(sgfPoint);
        this.blockStatusMap_.put(sgfPoint, blockStatus);
        return blockStatus;
    }

    private BlockStatus createBlockStatus(SgfPoint sgfPoint) {
        BlockStatus blockStatus = new BlockStatus();
        if (sgfPoint == null) {
            return blockStatus;
        }
        blockStatus.setPoint(sgfPoint);
        blockStatus.setPointTypes(this.nodeView_.getPointTypes(sgfPoint));
        blockStatus.setRectangle(this.calcBlockArea(sgfPoint));
        return blockStatus;
    }

    @Override
    public void setContext(CurrentContext currentContext) {
        ArgumentChecker.throwIfNull((Object)currentContext);
        this.context_ = currentContext;
        boolean bl = false;
        bl |= this.updateBlockLabelProvider();
        bl |= this.updateCoordinatesLabelProvider();
        bl |= this.updateVariationLabelProvider();
        if (this.showLastMoveMark_ != this.context_.getBoolean(Context.SHOW_LAST_MOVE_MARK)) {
            this.showLastMoveMark_ = !this.showLastMoveMark_;
            bl = true;
        }
        if (bl) {
            this.refresh();
        }
    }

    @Override
    public void update(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        this.nodeView_ = nodeView;
        this.blockedBoardDesigner_.update(nodeView);
        this.blockStatusMap_.clear();
        for (SgfPoint sgfPoint : nodeView.getIgoBoard().validate()) {
            BlockStatus blockStatus = this.createBlockStatus(sgfPoint);
            EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
            enumSet.add(SgfPointType.OVERLAP);
            blockStatus.setPointTypes(enumSet);
            this.blockStatusMap_.put(sgfPoint, blockStatus);
            this.blockedBoardDesigner_.addRedrawPoint(sgfPoint);
        }
        this.redraw();
    }

    private boolean updateStonePainter() {
        StonePainter stonePainter = this.context_.getProvider(StonePainter.class);
        if (!this.stonePainter_.equals(stonePainter)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.stonePainter_);
            this.stonePainter_ = stonePainter;
            this.blockedBoardDesigner_.addBlockPainter(this.stonePainter_);
            return true;
        }
        return false;
    }

    private boolean updateBlockLabelProvider() {
        BlockLabelProvider blockLabelProvider = this.context_.getProvider(BlockLabelProvider.class);
        if (!this.blockLabelProvider_.equals(blockLabelProvider)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.blockLabelProvider_);
            this.blockLabelProvider_ = blockLabelProvider;
            this.blockedBoardDesigner_.addBlockPainter(this.blockLabelProvider_);
            return true;
        }
        return false;
    }

    private boolean updateCoordinatesLabelProvider() {
        CoordinatesLabelProvider coordinatesLabelProvider = this.context_.getProvider(CoordinatesLabelProvider.class);
        this.coordinatesPainter_.setLabelProvider(coordinatesLabelProvider);
        return true;
    }

    private boolean updateVariationLabelProvider() {
        VariationLabelProvider variationLabelProvider = this.context_.getProvider(VariationLabelProvider.class);
        if (!this.variationLabelProvider_.equals(variationLabelProvider)) {
            this.variationLabelProvider_ = variationLabelProvider;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ModelEventNotifier,
    ContextMonitor {
        private Adapter() {
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            IgoGraphicalBoardPanel.this.context_ = gameMediator.getContext();
            IgoGraphicalBoardPanel.this.updateStonePainter();
            IgoGraphicalBoardPanel.this.updateBlockLabelProvider();
            IgoGraphicalBoardPanel.this.updateCoordinatesLabelProvider();
            IgoGraphicalBoardPanel.this.updateVariationLabelProvider();
            IgoGraphicalBoardPanel.this.showLastMoveMark_ = IgoGraphicalBoardPanel.this.context_.getBoolean(Context.SHOW_LAST_MOVE_MARK);
            IgoGraphicalBoardPanel.this.update(gameMediator.getCurrentNodeView());
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            IgoGraphicalBoardPanel.this.update(nodeView);
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            IgoGraphicalBoardPanel.this.eventBroker_.removeView(IgoGraphicalBoardPanel.this);
            IgoGraphicalBoardPanel.this.eventBroker_.disconnect();
            IgoGraphicalBoardPanel.this.eventBroker_ = eventBroker;
            IgoGraphicalBoardPanel.this.eventBroker_.addView(IgoGraphicalBoardPanel.this);
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            boolean bl = false;
            if (set.contains(StonePainter.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateStonePainter();
            }
            if (set.contains(BlockLabelProvider.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateBlockLabelProvider();
            }
            if (set.contains(CoordinatesLabelProvider.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateCoordinatesLabelProvider();
            }
            if (set.contains(VariationLabelProvider.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateVariationLabelProvider();
            }
            if (set.contains(Context.SHOW_LAST_MOVE_MARK.id())) {
                IgoGraphicalBoardPanel.this.showLastMoveMark_ = IgoGraphicalBoardPanel.this.context_.getBoolean(Context.SHOW_LAST_MOVE_MARK);
                bl = true;
            }
            if (set.contains(Context.MAX_STONE_SIZE.id())) {
                bl = true;
            }
            if (bl) {
                IgoGraphicalBoardPanel.this.refresh();
            }
        }
    }
}

