/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

public class OpenFileAction
extends Action {
    private static final Log log_s_ = LogFactory.getLog(OpenFileAction.class);
    private static final Message CLB_NAME = new Message(OpenFileAction.class, "clbName");
    private WindowController controller_ = null;

    public OpenFileAction() {
        this.setText(CLB_NAME.get());
    }

    public OpenFileAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        this.controller_ = windowController;
        return this;
    }

    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        IgoFileDialog igoFileDialog = new IgoFileDialog(Display.getCurrent().getActiveShell(), IgoFileChooser.Style.OPEN_FILES);
        igoFileDialog.open();
        for (File file : igoFileDialog.getFiles()) {
            if (!Yukinoshita.instance().checkFreeMemory()) {
                return;
            }
            this.openFileImpl(file);
        }
    }

    private void openFileImpl(File file) {
        Collection collection = FileManager.instance().open(file);
        if (collection == null) {
            return;
        }
        this.controller_.register(collection, null, false);
    }
}

