/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.ModelFrame;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.JFaceMenuManager;
import org.unitarou.yukinoshita.view.jface.dlg.AskSaveDialog;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.gm.GameSingleFrame;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceWindow
extends ApplicationWindow
implements Adaptable,
WindowController {
    private static final Log log_s_ = LogFactory.getLog(JFaceWindow.class);
    private static final String MARK_EDITED = "*";
    private static ImageResource[] IMG_APPS = null;
    private static final Message NT_FILE_SAVE_FAILURE = new Message(JFaceWindow.class, "ntFileSaveFailure");
    public static final Message NT_YUKINOSHITS = new Message(JFaceWindow.class, "ntYukinoshita");
    private static final IntArrayContextValue SIZE = new IntArrayContextValue(JFaceWindow.class, "size", 800, 640);
    private final JFaceMenuManager menuManager_;
    private CTabFolder tabFolder_ = null;
    private final Adapter adapter_;
    private final ShellAdapter shellAdapter_;
    private final Notifier notifier_;
    private final List<WindowControllerListener> listeners_ = new ArrayList<WindowControllerListener>();

    private static Image[] getAppIcons() {
        if (IMG_APPS == null) {
            IMG_APPS = new ImageResource[2];
            JFaceWindow.IMG_APPS[0] = new ImageResource(JFaceWindow.class, "iconApp16.png");
            JFaceWindow.IMG_APPS[1] = new ImageResource(JFaceWindow.class, "iconApp32.png");
        }
        return new Image[]{IMG_APPS[0].get(), IMG_APPS[1].get()};
    }

    public JFaceWindow(Shell shell) {
        super(shell);
        this.menuManager_ = new JFaceMenuManager(this);
        super.addMenuBar();
        this.adapter_ = new Adapter();
        this.shellAdapter_ = new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                JFaceWindow.this.closeThis(shellEvent);
            }
        };
        this.notifier_ = new Notifier();
    }

    private void closeThis(ShellEvent shellEvent) {
        shellEvent.doit = this.closeAllTabs();
        if (shellEvent.doit) {
            super.close();
        }
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void create() {
        super.create();
        this.menuManager_.initialize();
    }

    @Override
    protected Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.getShell().setImages(JFaceWindow.getAppIcons());
        this.getShell().setText(NT_YUKINOSHITS.get((Object)Yukinoshita.instance().getVersion()));
        this.tabFolder_ = new CTabFolder(composite, 2240);
        this.tabFolder_.setSimple(false);
        this.tabFolder_.addCTabFolder2Listener(new CTabFolder2Adapter(){

            public void close(CTabFolderEvent cTabFolderEvent) {
                GameFrameController gameFrameController = (GameFrameController)cTabFolderEvent.item.getData();
                cTabFolderEvent.doit = JFaceWindow.this.closeTab(gameFrameController);
                if (cTabFolderEvent.doit) {
                    cTabFolderEvent.item.setData(null);
                    cTabFolderEvent.item.dispose();
                    JFaceWindow.this.changeCurrentTabItem();
                }
            }
        });
        this.tabFolder_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JFaceWindow.this.changeCurrentTabItem();
            }
        });
        Display display = this.tabFolder_.getDisplay();
        this.tabFolder_.setSelectionBackground(new Color[]{display.getSystemColor(20), display.getSystemColor(22)}, new int[]{100}, true);
        CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
        int[] nArray = currentContext.getIntArray(SIZE);
        this.getShell().setSize(nArray[0], nArray[1]);
        return this.tabFolder_;
    }

    private void changeCurrentTabItem() {
        GameFrameController gameFrameController = this.getActive();
        for (WindowControllerListener object : this.listeners_) {
            object.changeActive(gameFrameController);
        }
        if (gameFrameController != null) {
            NodeView nodeView = gameFrameController.getCollectionEditor().getActiveGame().getCurrentNodeView();
            for (NodeMonitor nodeMonitor : gameFrameController.getEventBroker().getListeners(NodeMonitor.class)) {
                nodeMonitor.currentChanged(nodeView);
            }
        }
        this.updateFileModifyMark();
    }

    private void updateFileModifyMark() {
        String string;
        CTabItem cTabItem = this.tabFolder_.getSelection();
        if (cTabItem == null) {
            log_s_.warn("Selected tabitem is not found.");
            return;
        }
        GameFrameController gameFrameController = this.getActive();
        File file = gameFrameController.getCollection().getFile();
        String string2 = string = file != null ? file.getName() : cTabItem.getText();
        if (string.startsWith(MARK_EDITED)) {
            string = string.substring(MARK_EDITED.length());
        }
        cTabItem.setText(gameFrameController.isChanged() ? MARK_EDITED + string : string);
    }

    @Override
    protected ShellListener getShellListener() {
        return this.shellAdapter_;
    }

    private ModelFrame createGameFrame(String string) {
        GameSingleFrame gameSingleFrame = new GameSingleFrame();
        Control control = gameSingleFrame.createContents(this.tabFolder_);
        CTabItem cTabItem = new CTabItem(this.tabFolder_, 0);
        cTabItem.setText(string);
        cTabItem.setControl(control);
        this.tabFolder_.setSelection(cTabItem);
        return gameSingleFrame;
    }

    @Override
    protected MenuManager createMenuManager() {
        MenuManager menuManager = super.createMenuManager();
        this.menuManager_.createMenu(menuManager);
        return menuManager;
    }

    @Override
    public boolean close() {
        if (this.closeAllTabs()) {
            return super.close();
        }
        return false;
    }

    private boolean closeAllTabs() {
        CTabItem[] cTabItemArray = this.tabFolder_.getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            GameFrameController gameFrameController = (GameFrameController)cTabItemArray[i].getData();
            boolean bl = this.closeTab(gameFrameController);
            if (!bl) {
                return false;
            }
            cTabItemArray[i].setData(null);
            cTabItemArray[i].dispose();
        }
        return true;
    }

    private boolean closeTab(GameFrameController gameFrameController) {
        if (gameFrameController == null) {
            return true;
        }
        if (!gameFrameController.isChanged()) {
            FileManager.instance().close(gameFrameController.getCollection());
            gameFrameController.getEventBroker().removeView(this);
            gameFrameController.dispose();
            return true;
        }
        AskSaveDialog askSaveDialog = new AskSaveDialog(this.getShell(), gameFrameController);
        int n = askSaveDialog.open();
        switch (n) {
            case 1025: {
                File file = IgoFileDialog.askSaveFile(gameFrameController.getCollection());
                if (file == null) {
                    return false;
                }
                FileManager.instance().close(gameFrameController.getCollection());
                gameFrameController.getCollection().setFile(file);
            }
            case 1024: {
                try {
                    FileManager.instance().save(gameFrameController.getCollection());
                }
                catch (YukinoshitaException yukinoshitaException) {
                    log_s_.error(NT_FILE_SAVE_FAILURE.get(), yukinoshitaException);
                    MessageDialog.openError(this.getShell(), NT_FILE_SAVE_FAILURE.get(), yukinoshitaException.getLocalizedMessage());
                    return false;
                }
            }
            case 1026: {
                FileManager.instance().close(gameFrameController.getCollection());
                gameFrameController.getEventBroker().removeView(this);
                gameFrameController.dispose();
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void register(Collection collection, String string, boolean bl) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() == null && string == null) {
            throw new IllegalArgumentException("No tabName");
        }
        if (collection.getFile() != null) {
            string = collection.getFile().getName();
        }
        ModelFrame modelFrame = this.createGameFrame(string);
        GameFrameController gameFrameController = new GameFrameController(collection, modelFrame, bl);
        gameFrameController.getEventBroker().addView(this);
        this.notifier_.setEventBroker(gameFrameController.getEventBroker());
        this.tabFolder_.getSelection().setData(gameFrameController);
        this.changeCurrentTabItem();
    }

    @Override
    public GameFrameController getActive() {
        CTabItem cTabItem = this.tabFolder_.getSelection();
        return cTabItem != null ? (GameFrameController)cTabItem.getData() : null;
    }

    @Override
    public GameFrameController[] getGameFrameControllers() {
        CTabItem[] cTabItemArray = this.tabFolder_.getItems();
        GameFrameController[] gameFrameControllerArray = new GameFrameController[cTabItemArray.length];
        for (int i = 0; i < gameFrameControllerArray.length; ++i) {
            gameFrameControllerArray[i] = (GameFrameController)cTabItemArray[i].getData();
        }
        return gameFrameControllerArray;
    }

    @Override
    public boolean closeActive() {
        CTabItem cTabItem = this.tabFolder_.getSelection();
        if (cTabItem == null) {
            return false;
        }
        GameFrameController gameFrameController = (GameFrameController)cTabItem.getData();
        if (this.closeTab(gameFrameController)) {
            cTabItem.setData(null);
            cTabItem.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void addListener(WindowControllerListener windowControllerListener) {
        if (windowControllerListener != null) {
            this.listeners_.add(windowControllerListener);
        }
    }

    @Override
    public void removListener(WindowControllerListener windowControllerListener) {
        this.listeners_.remove(windowControllerListener);
    }

    @Override
    public void defaultLayout() {
        int[] nArray = SIZE.defaultIntArray();
        this.getShell().setSize(nArray[0], nArray[1]);
        GameFrameController gameFrameController = this.getActive();
        if (gameFrameController == null) {
            return;
        }
        for (LayoutMonitor layoutMonitor : gameFrameController.getEventBroker().getListeners(LayoutMonitor.class)) {
            layoutMonitor.defaultLayout();
        }
    }

    @Override
    public void loadLayout() {
        CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
        int[] nArray = currentContext.getIntArray(SIZE);
        this.getShell().setSize(nArray[0], nArray[1]);
        GameFrameController gameFrameController = this.getActive();
        if (gameFrameController == null) {
            return;
        }
        for (LayoutMonitor layoutMonitor : gameFrameController.getEventBroker().getListeners(LayoutMonitor.class)) {
            layoutMonitor.loadLayout();
        }
    }

    @Override
    public void saveLayout() {
        CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
        Point point = this.getShell().getSize();
        currentContext.setIntArray(SIZE.id(), new int[]{point.x, point.y});
        GameFrameController gameFrameController = this.getActive();
        if (gameFrameController == null) {
            Yukinoshita.context().save();
            return;
        }
        for (LayoutMonitor layoutMonitor : gameFrameController.getEventBroker().getListeners(LayoutMonitor.class)) {
            layoutMonitor.saveLayout();
        }
        Yukinoshita.context().save();
    }

    private class Notifier
    extends TieredModelEventNotifier {
        private Notifier() {
        }

        protected Adaptable[] getAdaptables() {
            return new Adaptable[]{JFaceWindow.this.menuManager_};
        }
    }

    private class Adapter
    implements GameMonitor,
    GameInfoNodeMonitor,
    NodeMonitor {
        private Adapter() {
        }

        public void update(GameMediator gameMediator) {
            JFaceWindow.this.updateFileModifyMark();
        }

        public void gameInfoUpdated(NodeView nodeView) {
            JFaceWindow.this.updateFileModifyMark();
        }

        public void currentChanged(NodeView nodeView) {
            JFaceWindow.this.updateFileModifyMark();
        }

        public void gameInfoChanged(NodeView nodeView) {
            JFaceWindow.this.updateFileModifyMark();
        }
    }
}

