/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.AddNode;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.InsertNode;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStone
extends Command4NodeList {
    private static final Message LB_NAME = new Message(SetStone.class, "lbName");
    private final SgfPoint point_;
    private final SgfColor color_;
    private Command4NodeList actualCommand_;
    private int nodeIndex_;

    public SetStone(SgfPoint sgfPoint, SgfColor sgfColor) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            throw new IllegalArgumentException("Set stone command dosen't permit PASS point");
        }
        this.point_ = sgfPoint;
        this.color_ = sgfColor;
        this.setDisplayName(LB_NAME.get((Object)this.getSetupType(this.color_).displayName()));
    }

    @Override
    protected boolean setup() {
        if (this.actualCommand_ != null) {
            return true;
        }
        EditableNodeList editableNodeList = this.getEditableNodeList();
        if (editableNodeList == null) {
            return false;
        }
        this.nodeIndex_ = editableNodeList.getPositionIndex();
        NodeEntity nodeEntity = editableNodeList.get(this.nodeIndex_);
        if (nodeEntity.getNode().contains(PropertyType.MOVE)) {
            this.setExecutedNodeIndex(this.nodeIndex_);
            this.setUndoneNodeIndex(this.nodeIndex_);
            this.actualCommand_ = this.makeCommandForMove();
        } else {
            this.setExecutedNodeIndex(this.nodeIndex_);
            this.setUndoneNodeIndex(this.nodeIndex_);
            this.actualCommand_ = this.makeCommandForRegular();
        }
        return true;
    }

    private Command4NodeList makeCommandForMove() {
        Command4NodeList command4NodeList;
        Node node = new Node(this.makeSetupMove(this.color_));
        if (this.getEditableNodeList().size() == this.nodeIndex_ + 1) {
            command4NodeList = new AddNode(node);
            command4NodeList.setEditableNodeList(this.getEditableNodeList());
        } else {
            command4NodeList = new InsertNode(this.getEditableNodeList(), node);
        }
        return command4NodeList;
    }

    private Command4NodeList makeCommandForRegular() {
        Object object;
        Property property = this.makeSetupMove(SgfColor.BLACK);
        Property property2 = this.makeSetupMove(SgfColor.WHITE);
        Property property3 = this.makeSetupMove(null);
        Property[] propertyArray = new Property[2];
        Property property4 = this.makeSetupMove(this.color_);
        if (SgfColor.BLACK.equals(this.color_)) {
            propertyArray[0] = property2;
            propertyArray[1] = property3;
        } else if (SgfColor.WHITE.equals(this.color_)) {
            propertyArray[0] = property;
            propertyArray[1] = property3;
        } else {
            propertyArray[0] = property;
            propertyArray[1] = property2;
            object = this.getEditableNodeList().get(this.nodeIndex_).getNode();
            block0: for (SgfId sgfId : new SgfId[]{SgfId.ADD_BLACK, SgfId.ADD_WHITE}) {
                Property property5 = ((Node)object).getProperty(sgfId);
                if (property5 == null) continue;
                for (String string : property5.getStrings()) {
                    if (!string.equals(this.point_.getString())) continue;
                    property4 = null;
                    continue block0;
                }
            }
        }
        object = new UpdateProperty(propertyArray, property4, null);
        ((Command4NodeList)object).setEditableNodeList(this.getEditableNodeList());
        return object;
    }

    private Property makeSetupMove(SgfColor sgfColor) {
        Property property = new Property();
        property.setId(this.getSetupType(sgfColor).id());
        property.addValue(new Value(this.point_.getString()));
        return property;
    }

    private SgfId getSetupType(SgfColor sgfColor) {
        if (SgfColor.BLACK.equals(sgfColor)) {
            return SgfId.ADD_BLACK;
        }
        if (SgfColor.WHITE.equals(sgfColor)) {
            return SgfId.ADD_WHITE;
        }
        return SgfId.ADD_EMPTY;
    }

    @Override
    public void execute() {
        super.execute();
        this.actualCommand_.execute();
    }

    @Override
    public void undo() {
        super.undo();
        this.actualCommand_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
    }
}

