/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.io.File;
import java.util.EnumSet;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFileName
extends Command4NodeList {
    private static final Message LB_NAME = new Message(ChangeFileName.class, "lbName");
    private final Collection collection_;
    private final File lastFile_;
    private final File newFile_;
    private Command command_;

    public ChangeFileName(Collection collection, File file) {
        ArgumentChecker.throwIfNull((Object)collection, (Object)file);
        this.collection_ = collection;
        this.lastFile_ = collection.getFile();
        this.newFile_ = file;
        this.command_ = null;
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    protected boolean setup() {
        if (this.command_ != null) {
            return true;
        }
        if (this.getEditableNodeList() == null) {
            return false;
        }
        this.command_ = this.composeCommand();
        return true;
    }

    private Command composeCommand() {
        String string;
        if (!this.collection_.get(0).getGameType().equals(GameType.DRILL)) {
            return NullCommand.INSTANCE;
        }
        String string2 = FilenameUtils.getFullPath(this.collection_.getFile().getAbsolutePath());
        if (string2.equals(string = FilenameUtils.getFullPath(this.newFile_.getAbsolutePath()))) {
            return NullCommand.INSTANCE;
        }
        EditableNodeList editableNodeList = this.getEditableNodeList();
        if (editableNodeList.size() < 2) {
            return NullCommand.INSTANCE;
        }
        for (int i = 0; i < editableNodeList.size(); ++i) {
            Property property = editableNodeList.get(i).getNode().getProperty(SgfId.INPUT_FILES);
            if (property == null) continue;
            this.setExecutedNodeIndex(editableNodeList.getPositionIndex());
            this.setUndoneNodeIndex(editableNodeList.getPositionIndex());
            editableNodeList.setPositionIndex(i);
            Property property2 = new Property();
            property2.setEntireId(SgfId.INPUT_FILES.id());
            for (Value value : property.getValues()) {
                String string3 = FilenameUtils.concat(string2, value.getString());
                Value value2 = new Value(Ios.calcRelativePath(string, string3), value.getOpenUtr());
                property2.addValue(value2);
            }
            return new UpdateCommand(property, property2, editableNodeList);
        }
        return NullCommand.INSTANCE;
    }

    @Override
    public void execute() {
        super.execute();
        this.command_.execute();
        this.collection_.setFile(this.newFile_);
    }

    @Override
    public void undo() {
        super.undo();
        this.collection_.setFile(this.lastFile_);
        this.command_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.COLLECTION);
    }

    private class UpdateCommand
    implements Command {
        private final UpdateProperty removeLast_;
        private final UpdateProperty addRepleaced_;

        private UpdateCommand(Property property, Property property2, EditableNodeList editableNodeList) {
            this.removeLast_ = new UpdateProperty(new Property[]{property}, null, null);
            this.addRepleaced_ = new UpdateProperty(new Property[0], property2, null);
            this.removeLast_.setEditableNodeList(editableNodeList);
            this.addRepleaced_.setEditableNodeList(editableNodeList);
        }

        public void execute() {
            this.removeLast_.execute();
            this.addRepleaced_.execute();
        }

        public void undo() {
            this.addRepleaced_.undo();
            this.removeLast_.undo();
        }
    }
}

