/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.MarkupIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableNodeList
implements NodeList {
    private static final Log log_s_ = LogFactory.getLog(EditableNodeList.class);
    private final RootGameTree root_;
    private final ArrayList<NodeEntity> entityList_;
    private int boardIndex_;
    private int positionIndex_;
    private MarkupIgoBoard igoBoard_;

    public EditableNodeList(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.root_ = rootGameTree;
        this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
        this.entityList_ = new ArrayList(this.root_.getGameType().equals(GameType.GAME) ? 300 : 20);
        this.boardIndex_ = -1;
        this.positionIndex_ = -1;
        this.addLast(this.root_);
    }

    public SgfSize getSize() {
        return this.root_.getSize();
    }

    public RootGameTree getRoot() {
        return this.root_;
    }

    void update(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int n = this.entityList_.indexOf(nodeEntity);
        if (n == -1) {
            throw new IllegalArgumentException("nodeEntity " + nodeEntity + " is not found in entityList_");
        }
        nodeEntity.updateVariationIndex();
        if (n == 0) {
            this.igoBoard_ = new MarkupIgoBoard(this.igoBoard_.size());
            nodeEntity.forwardUpdate(null, this.igoBoard_);
            this.boardIndex_ = -1;
        } else {
            this.updateIgoBoard(this.entityList_.get(n - 1));
        }
    }

    MarkupIgoBoard updateIgoBoard(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int n = this.entityList_.indexOf(nodeEntity);
        if (n == -1) {
            throw new IllegalArgumentException("nodeEntity " + nodeEntity + " is not found in entityList_");
        }
        if (this.boardIndex_ < n) {
            this.forwardUpdateIgoBoard(n);
            log_s_.debug("forwardUpdateIgoBoard:" + n);
        } else if (n < this.boardIndex_) {
            if (n != 0) {
                this.backwardUpdateIgoBoard(n - 1);
                log_s_.debug("backwardUpdateIgoBoard:" + (n - 1));
                this.forwardUpdateIgoBoard(n);
                log_s_.debug("forwardUpdateIgoBoard:" + n);
            } else {
                this.backwardUpdateIgoBoard(n);
                log_s_.debug("backwardUpdateIgoBoard:" + n);
            }
        }
        return this.igoBoard_;
    }

    private void forwardUpdateIgoBoard(int n) {
        for (int i = this.boardIndex_ + 1; i <= n; ++i) {
            NodeEntity nodeEntity = i == 0 ? null : this.entityList_.get(i - 1);
            this.entityList_.get(i).forwardUpdate(nodeEntity, this.igoBoard_);
        }
        this.boardIndex_ = n;
    }

    private void backwardUpdateIgoBoard(int n) {
        if (n == 0) {
            this.clearIgoBoard();
            return;
        }
        for (int i = this.boardIndex_; i >= n + 1; --i) {
            this.entityList_.get(i).backwardUpdate(this.igoBoard_);
        }
        this.boardIndex_ = n;
    }

    private void clearIgoBoard() {
        this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
        this.boardIndex_ = -1;
    }

    private void rollback(int n) {
        if (!this.entityList_.isEmpty()) {
            this.updateIgoBoard(this.entityList_.get(n));
        }
    }

    public void addLast(GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)gameTree);
        this.addLastImpl(gameTree);
    }

    private void addLastImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            this.entityList_.add(new NodeEntity(node, gameTree, this, this.entityList_.isEmpty() ? null : this.getLast()));
        }
        if (gameTree.getChildrenSize() != 0) {
            this.addLastImpl(gameTree.getChild(0));
        }
        SgfArgumentChecker.throwIfInvalid(this.root_);
    }

    public void addLast(NodeEntity[] nodeEntityArray) {
        ArgumentChecker.throwIfNull((Object)nodeEntityArray);
        for (NodeEntity nodeEntity : nodeEntityArray) {
            nodeEntity.updateVariationIndex();
            nodeEntity.setPrevious(this.entityList_.isEmpty() ? null : this.getLast());
            this.entityList_.add(nodeEntity);
        }
    }

    public void addLast(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        nodeEntity.updateVariationIndex();
        nodeEntity.setPrevious(this.entityList_.isEmpty() ? null : this.getLast());
        this.entityList_.add(nodeEntity);
    }

    public NodeEntity addLast(Node node, GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree);
        NodeEntity nodeEntity = new NodeEntity(node, gameTree, this, this.entityList_.isEmpty() ? null : this.getLast());
        this.entityList_.add(nodeEntity);
        return nodeEntity;
    }

    public NodeEntity insert(Node node, GameTree gameTree, NodeEntity nodeEntity) {
        SgfArgumentChecker.throwIfNotAChild(node, gameTree);
        int n = this.entityList_.indexOf(nodeEntity);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        NodeEntity nodeEntity2 = null;
        if (n == 0) {
            log_s_.warn("Can't rollback because of zero index");
        } else {
            this.rollback(n - 1);
            nodeEntity2 = this.get(n - 1);
        }
        NodeEntity nodeEntity3 = new NodeEntity(node, gameTree, this, nodeEntity2);
        nodeEntity3.setPrevious(this.entityList_.size() <= n ? null : this.entityList_.get(n - 1));
        this.entityList_.add(n, nodeEntity3);
        return nodeEntity3;
    }

    public boolean remove(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int n = this.entityList_.indexOf(nodeEntity);
        if (0 < n) {
            NodeEntity nodeEntity2 = this.entityList_.remove(n);
            nodeEntity2.setPrevious(null);
            this.rollback(n);
            return true;
        }
        return false;
    }

    public NodeEntity removeLast() {
        if (this.entityList_.isEmpty()) {
            throw new NoSuchElementException("entityList_ is empty");
        }
        if (this.entityList_.size() == 1) {
            this.clearIgoBoard();
        } else {
            this.rollback(this.entityList_.size() - 2);
        }
        NodeEntity nodeEntity = this.entityList_.remove(this.entityList_.size() - 1);
        nodeEntity.setPrevious(null);
        return nodeEntity;
    }

    public NodeEntity getPosition() {
        return this.get(this.positionIndex_);
    }

    public void setPositionIndex(int n) {
        if (n < 0 || this.entityList_.size() <= n) {
            throw new IndexOutOfBoundsException(n + " is out of range (size is " + this.entityList_.size() + ").");
        }
        this.positionIndex_ = n;
    }

    public int getPositionIndex() {
        return this.positionIndex_;
    }

    public NodeEntity get(int n) {
        return this.entityList_.get(n);
    }

    public NodeEntity getLast() {
        if (this.entityList_.isEmpty()) {
            throw new IllegalStateException("Current list is empty.");
        }
        return this.entityList_.get(this.entityList_.size() - 1);
    }

    @Override
    public int size() {
        return this.entityList_.size();
    }

    public boolean contains(NodeEntity nodeEntity) {
        return this.entityList_.contains(nodeEntity);
    }

    @Override
    public NodeView getLastNodeView() {
        return this.getLast().getNodeView();
    }

    @Override
    public NodeView getNodeView(int n) {
        return this.get(n).getNodeView();
    }

    @Override
    public NodeView getCurrentNodeView() {
        return this.getPosition().getNodeView();
    }

    public boolean refresh(Set<SgfId> set) {
        ArgumentChecker.throwIfNull(set);
        if (set.contains(SgfId.SIZE)) {
            this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
            this.entityList_.clear();
            this.boardIndex_ = -1;
            this.positionIndex_ = -1;
            this.addLast(this.root_);
            return true;
        }
        if (set.contains(SgfId.STYLE)) {
            if (this.root_.getStyle().isChildrenStyle()) {
                for (int i = 1; i < this.entityList_.size(); ++i) {
                    NodeEntity nodeEntity = this.entityList_.get(i - 1);
                    NodeEntity nodeEntity2 = this.entityList_.get(i);
                    nodeEntity.setSelectedVariationIndex(nodeEntity2.getUnmodifiedSelectVariationIndex());
                }
                this.entityList_.get(this.entityList_.size() - 1).setSelectedVariationIndex(-1);
            } else {
                for (int i = this.entityList_.size() - 1; 0 < i; --i) {
                    NodeEntity nodeEntity = this.entityList_.get(i - 1);
                    NodeEntity nodeEntity3 = this.entityList_.get(i);
                    nodeEntity3.setSelectedVariationIndex(nodeEntity.getUnmodifiedSelectVariationIndex());
                }
                this.entityList_.get(0).setSelectedVariationIndex(-1);
            }
            return true;
        }
        return false;
    }
}

