/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class SgfReal
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(SgfReal.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\+|-)?\\d+(|\\.\\d+)");
    private final double real_;

    public static SgfReal parse(String string) throws TypeParseException {
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        try {
            return new SgfReal(Double.parseDouble(matcher.group()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeParseException("Bad argument value = " + string);
        }
    }

    public static SgfReal parseQuietly(String string) {
        try {
            return SgfReal.parse(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.debug("Bad value for parse: " + string, typeParseException);
            return null;
        }
    }

    public SgfReal(double d) {
        this.real_ = d;
    }

    public double getReal() {
        return this.real_;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.REAL.equals((Object)sgfId.valueType());
    }

    public String getString() {
        return Double.toString(this.real_);
    }

    public boolean isValid(String string) {
        return condition_s_.matcher(string).matches();
    }

    public int compareTo(Object object) {
        SgfReal sgfReal = (SgfReal)object;
        return Double.compare(this.real_, sgfReal.real_);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SgfReal)) {
            return false;
        }
        SgfReal sgfReal = (SgfReal)object;
        return Double.doubleToLongBits(this.real_) == Double.doubleToLongBits(sgfReal.real_);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.real_);
        return (int)(l ^ l >>> 32);
    }
}

