/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.StringCharacterIterator;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.parser.SgfParserException;

@Deprecated
public class SgfStringFormatter {
    private BufferedWriter writer_;
    private boolean enableCaElement_;
    private boolean writeRegularId_;

    public void format(Collection collection, Writer writer, boolean bl, boolean bl2) throws SgfParserException {
        try {
            this.writer_ = new BufferedWriter(writer);
            this.enableCaElement_ = bl;
            this.writeRegularId_ = bl2;
            if (collection == null || writer == null) {
                throw new NullPointerException();
            }
            for (int i = 0; i < collection.size(); ++i) {
                RootGameTree rootGameTree = collection.get(i);
                if (0 == rootGameTree.getSequence().size()) continue;
                Node node = rootGameTree.getSequence().getFirst();
                if (!this.enableCaElement_) {
                    node.removeProperty(SgfId.CHARSET.id());
                }
                this.format(rootGameTree);
            }
            this.writer_.flush();
        }
        catch (IOException iOException) {
            throw new SgfParserException(iOException);
        }
        finally {
            this.writer_ = null;
        }
    }

    private void format(GameTree gameTree) throws IOException {
        this.writer_.write(gameTree.getOpenUtr());
        this.writer_.write(40);
        Node[] nodeArray = gameTree.getSequence().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.format(nodeArray[i]);
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.format(gameTreeArray[i]);
        }
        this.writer_.write(41);
        this.writer_.write(gameTree.getCloseUtr());
    }

    private void format(Node node) throws IOException {
        this.writer_.write(node.getOpenUtr());
        this.writer_.write(59);
        Property[] propertyArray = node.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.format(propertyArray[i]);
        }
    }

    private void format(Property property) throws IOException {
        this.writer_.write(property.getOpenUtr());
        this.writer_.write(this.writeRegularId_ ? property.getId() : property.getEntireId());
        Value[] valueArray = property.getValues();
        for (int i = 0; i < valueArray.length; ++i) {
            this.writer_.write(valueArray[i].getOpenUtr());
            this.writer_.write(91);
            this.writer_.write(this.escapeBracket(valueArray[i].getString()));
            this.writer_.write(93);
        }
        this.writer_.write(property.getCloseUtr());
    }

    private String escapeBracket(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuilder.append(c);
                c = stringCharacterIterator.next();
                if (c == '\uffff') {
                    stringBuilder.append('\\');
                    break;
                }
            } else if (c == ']') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }
}

