/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.UEnum;
import org.unitarou.util.ArgumentChecker;

public class SgfParserLogger {
    public static final Level INFO = new Level(0, "INFO");
    public static final Level WARN = new Level(1000, "WARN");
    public static final Level ERROR = new Level(2000, "ERROR");
    private final List<Message> messages_;

    public SgfParserLogger() {
        this.messages_ = new ArrayList<Message>();
    }

    public SgfParserLogger(SgfParserLogger sgfParserLogger) {
        ArgumentChecker.throwIfNull((Object)sgfParserLogger);
        this.messages_ = new ArrayList<Message>(sgfParserLogger.messages_);
    }

    public void addMessage(Message message) {
        ArgumentChecker.throwIfNull((Object)message);
        this.messages_.add(message);
    }

    public void error(int n, String string, String string2) {
        this.addMessage(new Message(ERROR, n, string, string2));
    }

    public void warn(int n, String string, String string2) {
        this.addMessage(new Message(WARN, n, string, string2));
    }

    public void info(int n, String string, String string2) {
        this.addMessage(new Message(INFO, n, string, string2));
    }

    public Message[] getMessages(Level level) {
        ArgumentChecker.throwIfNull((Object)level);
        ArrayList<Message> arrayList = new ArrayList<Message>(this.messages_.size());
        for (int i = 0; i < this.messages_.size(); ++i) {
            Message message = this.messages_.get(i);
            if (level.rank_ > message.level_.rank_) continue;
            arrayList.add(message);
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    public Message[] getAllMessages() {
        return this.messages_.toArray(new Message[this.messages_.size()]);
    }

    public static class Message {
        private final Level level_;
        private final int line_;
        private final String message_;
        private final String fragment_;

        public Message(Level level, int n, String string, String string2) {
            this.level_ = level;
            this.line_ = n;
            this.message_ = string;
            this.fragment_ = string2;
        }

        public Level getLevel() {
            return this.level_;
        }

        public int getLine() {
            return this.line_;
        }

        public String getMessage() {
            return this.message_;
        }

        public String getFragment() {
            return this.fragment_;
        }
    }

    public static class Level
    extends UEnum {
        private final int rank_;

        protected Level(int n, String string) {
            super((Comparable)((Object)string));
            this.rank_ = n;
        }

        public int getRank() {
            return this.rank_;
        }
    }
}

