/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.util.ArgumentChecker;

public class SgfFormatter {
    private static final Log log_s_ = LogFactory.getLog(SgfFormatter.class);
    private static final Message SP_DEFAULT_ENCODE_CHARSET = new Message(SgfFormatter.class, "spDefaultEncodeCharset");
    public static final Charset DEFAULT_ENCODE_CHARSET;
    private boolean writeRegularId_ = false;
    private StringWriter writer_;

    /*
     * WARNING - void declaration
     */
    public ByteBuffer format(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(collection.size());
        int n = 0;
        for (int i = 0; i < collection.size(); ++i) {
            void comparable;
            void var6_10;
            Charset charset;
            this.writer_ = new StringWriter();
            RootGameTree rootGameTree = collection.get(i);
            if (0 == rootGameTree.getSequence().size()) continue;
            SgfCharset sgfCharset = rootGameTree.getSgfCharset();
            if (sgfCharset == null) {
                SgfCharset sgfCharset2 = new SgfCharset(rootGameTree.getActualCharset());
            }
            if (!(charset = var6_10.getCharset()).canEncode()) {
                SgfCharset sgfCharset3 = new SgfCharset(Charset.defaultCharset());
            }
            rootGameTree.setCharset((SgfCharset)comparable);
            this.format(rootGameTree);
            this.writer_.flush();
            ByteBuffer byteBuffer = comparable.getCharset().encode(this.writer_.toString());
            arrayList.add(byteBuffer);
            n += byteBuffer.limit();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (ByteBuffer byteBuffer2 : arrayList) {
            byteBuffer.put(byteBuffer2);
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public String formatAsString(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        this.writer_ = new StringWriter();
        for (int i = 0; i < collection.size(); ++i) {
            RootGameTree rootGameTree = collection.get(i);
            if (0 == rootGameTree.getSequence().size()) continue;
            this.format(rootGameTree);
        }
        this.writer_.flush();
        return this.writer_.toString();
    }

    private void format(GameTree gameTree) {
        this.writer_.write(gameTree.getOpenUtr());
        this.writer_.write(40);
        Node[] nodeArray = gameTree.getSequence().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.format(nodeArray[i]);
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.format(gameTreeArray[i]);
        }
        this.writer_.write(41);
        this.writer_.write(gameTree.getCloseUtr());
    }

    private void format(Node node) {
        this.writer_.write(node.getOpenUtr());
        this.writer_.write(59);
        Property[] propertyArray = node.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.format(propertyArray[i]);
        }
    }

    private void format(Property property) {
        this.writer_.write(property.getOpenUtr());
        this.writer_.write(this.writeRegularId_ ? property.getId() : property.getEntireId());
        Value[] valueArray = property.getValues();
        if (property.sgfId().equals(SgfId.INPUT_FILES)) {
            for (int i = 0; i < valueArray.length; ++i) {
                this.writer_.write(valueArray[i].getOpenUtr());
                this.writer_.write(91);
                this.writer_.write(Sgfs.escapeIfForStore(valueArray[i].getString()));
                this.writer_.write(93);
            }
        } else {
            for (int i = 0; i < valueArray.length; ++i) {
                this.writer_.write(valueArray[i].getOpenUtr());
                this.writer_.write(91);
                this.writer_.write(Sgfs.escapeForStore(valueArray[i].getString()));
                this.writer_.write(93);
            }
        }
        this.writer_.write(property.getCloseUtr());
    }

    static {
        Charset charset = null;
        try {
            charset = Charset.forName(SP_DEFAULT_ENCODE_CHARSET.get());
            if (!charset.canEncode()) {
                charset = Charset.defaultCharset();
                log_s_.warn("Bad argument, needs encodable charset:" + SP_DEFAULT_ENCODE_CHARSET.get() + ". Use default charset" + charset.displayName());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log_s_.warn("Unknown charset:" + SP_DEFAULT_ENCODE_CHARSET.get());
            charset = Charset.defaultCharset();
        }
        DEFAULT_ENCODE_CHARSET = charset;
    }
}

