/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ImageResource;

public class CursorResource
extends ImageResource {
    private static final Log log_s_ = LogFactory.getLog(CursorResource.class);
    private static final Map<String, Cursor> cursorMap_s_ = new TreeMap<String, Cursor>();
    private static final DisposeListener disposeListener_s_ = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            Iterator iterator = cursorMap_s_.values().iterator();
            while (iterator.hasNext()) {
                ((Cursor)iterator.next()).dispose();
            }
            cursorMap_s_.clear();
        }
    };
    private Cursor cursor_ = null;
    private final Point hotspot_;

    public CursorResource(Class clazz, String string, Point point) {
        super(clazz, string);
        this.hotspot_ = point;
    }

    public Cursor getCursor() {
        if (this.cursor_ == null) {
            this.setup();
        } else if (this.cursor_.isDisposed()) {
            log_s_.warn("Cursor (" + this.key_ + "has been disposed (SWT bug?)");
            this.setup();
        }
        return this.cursor_;
    }

    private void setup() {
        ImageData imageData = this.getImageData();
        if (imageData == null) {
            log_s_.warn("Can't find image [" + this.key_ + "] use MissingImage.");
            imageData = ImageDescriptor.getMissingImageDescriptor().getImageData();
        }
        this.cursor_ = new Cursor(Display.getCurrent(), imageData, this.hotspot_.x, this.hotspot_.y);
        if (cursorMap_s_.isEmpty()) {
            Display.getDefault().getActiveShell().addDisposeListener(disposeListener_s_);
        }
        cursorMap_s_.put(this.key_, this.cursor_);
    }
}

