/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.clp;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.yukinoshita.view.provider.clp.CollectionLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;

public class ForFileNameCollectionProvider
implements CollectionLabelProvider {
    private static Message LB_RGT_GAME_COUNTER = new Message(ForFileNameCollectionProvider.class, "lbRgtGameCounter");
    private static Message LB_RGT_PROBLEM_COUNTER = new Message(ForFileNameCollectionProvider.class, "lbRgtProblemCounter");

    public String getLabel(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        GreedyRgtLabelProvider greedyRgtLabelProvider = new GreedyRgtLabelProvider();
        for (RootGameTree rootGameTree : collection) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(greedyRgtLabelProvider.getLabel(rootGameTree));
            }
            switch (rootGameTree.getGameType()) {
                case GAME: {
                    ++n;
                    break;
                }
                case PROBLEM: {
                    ++n2;
                    break;
                }
            }
        }
        if (n + n2 <= 1) {
            return stringBuilder.toString();
        }
        if (n != 0) {
            stringBuilder.append('[').append(LB_RGT_GAME_COUNTER.get((Object)n));
        }
        if (n2 != 0) {
            stringBuilder.append(n != 0 ? (char)',' : '[').append(LB_RGT_PROBLEM_COUNTER.get((Object)n2)).append(']');
        }
        return stringBuilder.toString();
    }
}

