/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.provider.abp;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import org.eclipse.swt.graphics.FontData;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.view.jface.provider.abp.AbstractAsciiBoardProvider;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardOption;

public class JapaneseAsciiBoardProvider
extends AbstractAsciiBoardProvider {
    private static final Message LB_DISPLAY_NAME = new Message(JapaneseAsciiBoardProvider.class, "lbDisplayName");
    private static final ContextValue<FontData> FONT_DATA = new ContextValue<FontData>(JapaneseAsciiBoardProvider.class, "fontData", new FontData("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 12, 0));
    private static final ContextValue<EnumSet<AsciiBoardOption>> OPTIONS = new ContextValue<EnumSet<AsciiBoardOption>>(JapaneseAsciiBoardProvider.class, "options", EnumSet.of(AsciiBoardOption.DECOLATE_STARS, AsciiBoardOption.SHOW_COORDINATE, AsciiBoardOption.DECOLATE_EDGE));
    private static final String[] COORD_LABELS = new String[]{"", "____A", "_B", "_C", "_D", "_.E", "_F", "_G", "_H", "_.J", "_.K", "_L", "_M", "_.N", "_O", "_P", "_Q", "_R", "_.S", "_T"};
    private final NumberFormat numberFormat_ = new DecimalFormat("00");

    public JapaneseAsciiBoardProvider() {
        super(FONT_DATA, OPTIONS);
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    public boolean isSupported(AsciiBoardOption asciiBoardOption) {
        ArgumentChecker.throwIfNull((Object)asciiBoardOption);
        switch (asciiBoardOption) {
            case DECOLATE_EDGE: 
            case DECOLATE_STARS: 
            case SHOW_COORDINATE: {
                return true;
            }
        }
        return false;
    }

    protected void appendStartCoordinalte(StringBuilder stringBuilder, int n, int n2) {
        for (int i = n; i <= Math.min(n2, 19); ++i) {
            stringBuilder.append(COORD_LABELS[i]);
        }
        stringBuilder.append(Strings.LINE_SEPARATOR);
    }

    protected void appendEndCoordinalte(StringBuilder stringBuilder, int n, int n2) {
        this.appendStartCoordinalte(stringBuilder, n, n2);
    }

    protected void appendLeftCoordinalte(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this.numberFormat_.format(n));
    }

    protected void appendRightCoordinalte(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this.numberFormat_.format(n));
    }

    protected CharSequence get(AbstractAsciiBoardProvider.PointType pointType) {
        switch (pointType) {
            case BLACK: {
                return "\u25cf";
            }
            case L_BLACK: {
                return "\u2605";
            }
            case WHITE: {
                return "\u25cb";
            }
            case L_WHITE: {
                return "\u2606";
            }
            case TOP_LEFT: {
                return "\u250c";
            }
            case E_TOP_LEFT: {
                return "\u250f";
            }
            case TOP: {
                return "\u252c";
            }
            case E_TOP: {
                return "\u252f";
            }
            case TOP_RIGHT: {
                return "\u2510";
            }
            case E_TOP_RIGHT: {
                return "\u2513";
            }
            case LEFT: {
                return "\u251c";
            }
            case E_LEFT: {
                return "\u2520";
            }
            case CENTER: {
                return "\u253c";
            }
            case STAR: {
                return "\u254b";
            }
            case RIGHT: {
                return "\u2524";
            }
            case E_RIGHT: {
                return "\u2528";
            }
            case BOTTOM_LEFT: {
                return "\u2514";
            }
            case E_BOTTOM_LEFT: {
                return "\u2517";
            }
            case BOTTOM: {
                return "\u2534";
            }
            case E_BOTTOM: {
                return "\u2537";
            }
            case BOTTOM_RIGHT: {
                return "\u2518";
            }
            case E_BOTTOM_RIGHT: {
                return "\u251b";
            }
        }
        return "\u3000";
    }
}

