/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pref;

import java.util.EnumSet;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.IntContextValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEditorBuilder {
    public static IntegerFieldEditor buildForInteger(Composite composite, IntContextValue intContextValue) {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(intContextValue.id(), intContextValue.displayName(), composite);
        integerFieldEditor.setEmptyStringAllowed(false);
        integerFieldEditor.setValidRange(intContextValue.minInt(), intContextValue.maxInt());
        integerFieldEditor.setErrorMessage(intContextValue.errorMessage());
        return integerFieldEditor;
    }

    public static BooleanFieldEditor buildForBoolean(Composite composite, ContextValue<Boolean> contextValue) {
        return new BooleanFieldEditor(contextValue.id(), contextValue.displayName(), composite);
    }

    public static <T extends Provider> RadioGroupFieldEditor buildForProvider(Composite composite, ContextValue<T> contextValue, Class<T> clazz, int n) {
        return new RadioGroupFieldEditor(contextValue.id(), contextValue.displayName(), n, FieldEditorBuilder.composeProviderSelector(clazz), composite, true);
    }

    public static <T extends Provider> String[][] composeProviderSelector(Class<T> clazz) {
        Provider[] providerArray = Yukinoshita.context().getProviders(clazz);
        String[][] stringArray = new String[providerArray.length][];
        for (int i = 0; i < providerArray.length; ++i) {
            stringArray[i] = new String[]{providerArray[i].displayName(), providerArray[i].getClass().getName()};
        }
        return stringArray;
    }

    public static <E extends Enum<E>> RadioGroupFieldEditor buildForEnum(Composite composite, ContextValue<E> contextValue, Class<E> clazz, int n) {
        return new RadioGroupFieldEditor(contextValue.id(), contextValue.displayName(), n, FieldEditorBuilder.composeEnumSelector(clazz), composite, true);
    }

    public static <E extends Enum<E>> String[][] composeEnumSelector(Class<E> clazz) {
        EnumSet<Enum> enumSet = EnumSet.allOf(clazz);
        String[][] stringArray = new String[enumSet.size()][];
        int n = 0;
        for (Enum enum_ : enumSet) {
            stringArray[n] = new String[]{enum_.toString(), enum_.name()};
            ++n;
        }
        return stringArray;
    }
}

