/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.util.EventListener;
import org.eclipse.swt.widgets.Display;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.swt.ListenerList;

class Timer {
    private final ListenerList<TimerListener> listenerList_ = new ListenerList<TimerListener>(TimerListener.class, 1);
    private int timeLimit_;
    private int timeLeft_ = this.timeLimit_ = 0;
    private Clock clock_ = null;

    Timer() {
    }

    void setTimeLimit(int n) {
        ArgumentChecker.throwIfNegative(n);
        this.timeLimit_ = n;
    }

    void addListener(TimerListener timerListener) {
        if (timerListener != null) {
            this.listenerList_.add(timerListener);
        }
    }

    void removeListener(TimerListener timerListener) {
        this.listenerList_.remove(timerListener);
    }

    synchronized void start() {
        this.timeLeft_ = this.timeLimit_;
        this.restart();
    }

    synchronized void pause() {
        this.stop();
    }

    synchronized void restart() {
        if (this.clock_ != null) {
            this.clock_.interrupt();
        }
        this.clock_ = new Clock();
        this.clock_.start();
    }

    synchronized void stop() {
        if (this.clock_ == null) {
            return;
        }
        this.clock_.interrupt();
        this.clock_ = null;
    }

    int timeLimit() {
        return this.timeLimit_;
    }

    int timeLeft() {
        return this.timeLeft_;
    }

    private void countDown() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (TimerListener timerListener : (TimerListener[])Timer.this.listenerList_.getListeners()) {
                    timerListener.countDown();
                }
            }
        });
    }

    private void timeup() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (TimerListener timerListener : (TimerListener[])Timer.this.listenerList_.getListeners()) {
                    timerListener.timeup();
                }
            }
        });
    }

    private class Clock
    extends Thread {
        public Clock() {
            super("Timer Clock");
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                while (true) {
                    long l2;
                    int n;
                    if ((n = (int)(((l2 = System.currentTimeMillis()) - l) / 1000L)) != 0) {
                        l += (long)(n * 1000);
                        Timer.this.timeLeft_ -= n;
                        Timer.this.countDown();
                    }
                    if (Timer.this.timeLeft_ <= 0) {
                        Timer.this.timeLeft_ = 0;
                        Timer.this.timeup();
                        return;
                    }
                    Thread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    static interface TimerListener
    extends EventListener {
        public void countDown();

        public void timeup();
    }
}

