/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.EnumSet;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

class NodeListLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final Log log_s_ = LogFactory.getLog(NodeListLabelProvider.class);
    private static final ImageRegistry imageRegistry_s_ = JFaceResources.getImageRegistry();
    private static final ColorResource BACKGROUND = new ColorResource(25);
    private static final ColorResource MAIN_FONT = new ColorResource(24);
    private static final ColorResource[] VARIATIONS;
    private CoordinatesLabelProvider coordinatesLabelProvider_ = Yukinoshita.context(null).getProvider(CoordinatesLabelProvider.class);

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getColumnImage(Object object, int n) {
        Object object2;
        NodeStatus nodeStatus2;
        if (!(object instanceof NodeView) || n != 0) {
            return null;
        }
        NodeView nodeView = (NodeView)object;
        EnumSet<NodeStatus> enumSet = EnumSet.noneOf(NodeStatus.class);
        if (nodeView.getProperty(SgfId.WHITE) != null) {
            enumSet.add(NodeStatus.WHITE_MOVE);
        } else if (nodeView.getProperty(SgfId.BLACK) != null) {
            enumSet.add(NodeStatus.BLACK_MOVE);
        }
        if (nodeView.variationSize() != 0) {
            enumSet.add(NodeStatus.HAS_VARIATION);
        }
        if (!nodeView.getInvalid().isEmpty()) {
            enumSet.add(NodeStatus.WARNING);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().toString()).append('/');
        for (NodeStatus nodeStatus2 : enumSet) {
            stringBuilder.append(nodeStatus2.name()).append(':');
        }
        String string = stringBuilder.toString();
        nodeStatus2 = imageRegistry_s_.get(string);
        if (nodeStatus2 != null) {
            return nodeStatus2;
        }
        GC gC = null;
        try {
            nodeStatus2 = new Image(null, 16, 16);
            gC = new GC((Drawable)nodeStatus2);
            for (NodeStatus nodeStatus3 : enumSet) {
                gC.drawImage(nodeStatus3.imageResource_.get(), 0, 0);
            }
            imageRegistry_s_.put(string, (Image)nodeStatus2);
            object2 = nodeStatus2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC);
        return object2;
    }

    public String getColumnText(Object object, int n) {
        if (!(object instanceof NodeView)) {
            return null;
        }
        NodeView nodeView = (NodeView)object;
        switch (n) {
            case 0: {
                return this.getMoveNumber(nodeView);
            }
            case 1: {
                return this.getTimeLapsed(nodeView);
            }
            case 2: {
                return this.getMoveText(nodeView);
            }
            case 3: {
                return this.getTreeText(nodeView);
            }
        }
        return "";
    }

    private String getMoveNumber(NodeView nodeView) {
        StringBuilder stringBuilder = new StringBuilder();
        Integer n = nodeView.getMove().getNumber();
        if (n != null) {
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    private String getTimeLapsed(NodeView nodeView) {
        StringBuilder stringBuilder = new StringBuilder();
        Double d = nodeView.getMove().getTimeLapsed();
        if (d != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('[').append(Strings.composeDuration(d.intValue())).append(']');
        }
        return stringBuilder.toString();
    }

    private String getMoveText(NodeView nodeView) {
        Property property = null;
        try {
            property = nodeView.getProperty(SgfId.WHITE);
            if (property != null) {
                SgfPoint sgfPoint = SgfPoint.parseMove(nodeView.getSize(), property.getString());
                return this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
            property = nodeView.getProperty(SgfId.BLACK);
            if (property != null) {
                SgfPoint sgfPoint = SgfPoint.parseMove(nodeView.getSize(), property.getString());
                return this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
        }
        catch (TypeParseException typeParseException) {
            log_s_.log(LogLevel.WARN, "Parse error: {0} Ignore this property: {1}", typeParseException.getLocalizedMessage(), property);
        }
        return "";
    }

    private String getTreeText(NodeView nodeView) {
        return NodeViewLabelProvider.CONTEXT.defaultValue().getLabel(nodeView);
    }

    public CoordinatesLabelProvider getProvider() {
        return this.coordinatesLabelProvider_;
    }

    public Color getForeground(Object object, int n) {
        return MAIN_FONT.get();
    }

    public Color getBackground(Object object, int n) {
        if (n == 0 || !(object instanceof NodeView)) {
            return BACKGROUND.get();
        }
        NodeView nodeView = (NodeView)object;
        int n2 = nodeView.getVariationHash();
        if (-1 == n2) {
            return BACKGROUND.get();
        }
        return VARIATIONS[n2 % VARIATIONS.length].get();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void setProvider(CoordinatesLabelProvider coordinatesLabelProvider) {
        ArgumentChecker.throwIfNull((Object)coordinatesLabelProvider);
        this.coordinatesLabelProvider_ = coordinatesLabelProvider;
    }

    static {
        int[] nArray = new int[]{238, 221};
        int[] nArray2 = new int[]{238, 221};
        int[] nArray3 = new int[]{238, 221};
        VARIATIONS = new ColorResource[nArray.length * nArray2.length * nArray3.length - nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray3.length; ++j) {
                for (int k = 0; k < nArray2.length; ++k) {
                    if (i == j && j == k) continue;
                    NodeListLabelProvider.VARIATIONS[n] = new ColorResource(nArray[i], nArray2[k], nArray3[j]);
                    ++n;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeStatus {
        WHITE_MOVE(NodeImage.WHITE),
        BLACK_MOVE(NodeImage.BLACK),
        HAS_VARIATION(NodeImage.VNONE),
        WARNING(NodeImage.WARNING);

        private final ImageResource imageResource_;

        private NodeStatus(ImageResource imageResource) {
            this.imageResource_ = imageResource;
        }
    }
}

