/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.Message;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.view.jface.dr.IfElement;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

class IfLabelProvider
extends LabelProvider
implements IColorProvider {
    private static final Message LB_NOTFOUND = new Message(IfLabelProvider.class, "lbNotfound");
    private static final Message LB_CANNTO_READ = new Message(IfLabelProvider.class, "lbCannotRead");
    private static final Message LB_ERROR_FRAME = new Message(IfLabelProvider.class, "lbErrorFrame");

    IfLabelProvider() {
    }

    public Image getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof IfElement) {
            IfElement ifElement = (IfElement)object;
            File file = ifElement.getInputFile();
            StringBuilder stringBuilder = new StringBuilder();
            if (!file.exists() || !file.isFile()) {
                stringBuilder.append(LB_ERROR_FRAME.get(LB_NOTFOUND.get(), ifElement.getInputFileName()));
            } else if (!file.canRead()) {
                stringBuilder.append(LB_ERROR_FRAME.get(LB_CANNTO_READ.get(), ifElement.getInputFileName()));
            } else {
                stringBuilder.append(ifElement.getInputFileName());
            }
            return stringBuilder.toString();
        }
        if (object instanceof RootGameTree) {
            RootGameTree rootGameTree = (RootGameTree)object;
            if (rootGameTree.getGameType().equals(GameType.PROBLEM)) {
                return RootGameTreeLabelProvider.CONTEXT.defaultValue().getLabel((RootGameTree)object);
            }
            return LB_ERROR_FRAME.get(rootGameTree.getGameType().displayName(), RootGameTreeLabelProvider.CONTEXT.defaultValue().getLabel((RootGameTree)object));
        }
        return super.getText(object);
    }

    public Color getForeground(Object object) {
        if (object instanceof IfElement) {
            IfElement ifElement = (IfElement)object;
            File file = ifElement.getInputFile();
            return file.exists() && file.isFile() ? Display.getCurrent().getSystemColor(16) : Display.getCurrent().getSystemColor(3);
        }
        if (object instanceof RootGameTree) {
            RootGameTree rootGameTree = (RootGameTree)object;
            if (rootGameTree.getGameType().equals(GameType.PROBLEM)) {
                return Display.getCurrent().getSystemColor(2);
            }
            return Display.getCurrent().getSystemColor(3);
        }
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }
}

