/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.jface.dlg.ExplorerLikeFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.FileDialogStyle;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;
import org.unitarou.yukinoshita.view.jface.dlg.SwtFileChooser;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;

public class IgoFileDialog {
    public static final ContextValue<FileDialogStyle> FILE_DIALOG_STYLE = new ContextValue<FileDialogStyle>(IgoFileDialog.class, "fileDialogStyle", FileDialogStyle.ORIGINAL);
    private static final Message NT_FILE_OPEN = new Message(IgoFileDialog.class, "ntFileOpen");
    private static final Message NT_FILE_OPEN_MULTI = new Message(IgoFileDialog.class, "ntFileOpenMulti");
    private static final Message NT_FILE_SAVE = new Message(IgoFileDialog.class, "ntFileSave");
    private static final Message NT_CONFIRM_OVERWRITE = new Message(IgoFileDialog.class, "ntConfirmOverwrite");
    private static final Message MSG_FILE_IS_EXISTS_OVERWRITE = new Message(IgoFileDialog.class, "msgFileIsExistsOverwrite");
    private static final Message CLB_OVERWRITE = new Message(IgoFileDialog.class, "clbOverwrite");
    private static final Message CLB_SAVE_ANOTHER_NAME = new Message(IgoFileDialog.class, "clbSaveAnotherName");
    private static final Message NT_BAD_ASSIGN = new Message(IgoFileDialog.class, "ntBadAssign");
    private static final Message MSG_ASSIGN_NO_DIRECTORY = new Message(IgoFileDialog.class, "msgAssignNoDirectory");
    private static final Message MSG_ASSIGN_WRITABLE = new Message(IgoFileDialog.class, "msgAssignWritable");
    private static final Message NT_FILTER_SGF = new Message(IgoFileDialog.class, "ntFilterSgf");
    private static final Message NT_FILTER_ALL = new Message(IgoFileDialog.class, "ntFilterAll");
    private static final String FILE_FILTER_SGF = "*.sgf";
    private static final String FILE_FILTER_ALL = "*.*";
    private static final ContextValue<File> CURRENT_FOLDER = new ContextValue<File>(IgoFileDialog.class, "currentFolder", Ios.getCurrentDirectory());
    private IgoFileChooser fileDialog_;
    private final Shell parent_;
    private final IgoFileChooser.Style style_;
    private final CurrentContext context_;
    private String filename_;
    private File currentDirectory_;

    public static File askSaveFile(Collection collection) {
        File file;
        Object object;
        ArgumentChecker.throwIfNull((Object)collection);
        File file2 = collection.getFile();
        if (file2 == null) {
            file2 = Ios.getCurrentDirectory();
            object = new GreedyRgtLabelProvider().getLabel(collection.get(0));
            object = Ios.toValidFilename((String)object);
            file2 = new File(file2, (String)object + '.' + "sgf");
        }
        while (true) {
            object = new IgoFileDialog(Display.getCurrent().getActiveShell(), IgoFileChooser.Style.SAVE_FILE);
            ((IgoFileDialog)object).setFolder(file2);
            if (!((IgoFileDialog)object).open()) {
                return null;
            }
            file = ((IgoFileDialog)object).getFile();
            if (!Ios.isTemporaryFile(file)) break;
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, BasicMessages.NT_FILE_SAVE_FAILURE.get(), Ios.MSG_CANT_WRITE_TO_TMP_FILE.get((Object)file.getAbsolutePath()));
        }
        return file;
    }

    public IgoFileDialog(Shell shell) {
        this(shell, IgoFileChooser.Style.OPEN_FILE);
    }

    public IgoFileDialog(Shell shell, IgoFileChooser.Style style) {
        ArgumentChecker.throwIfNull((Object)shell, (Object)style);
        this.fileDialog_ = null;
        this.parent_ = shell;
        this.style_ = style;
        this.context_ = Yukinoshita.context().getCurrent(null);
        this.filename_ = "";
        this.currentDirectory_ = this.context_.getAttribute(CURRENT_FOLDER);
    }

    public boolean open() {
        boolean bl;
        if (this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE)) {
            bl = this.openAsSave();
        } else {
            this.createFileDialog();
            bl = this.fileDialog_.chooseFile();
        }
        if (bl) {
            this.context_.setAttribute(CURRENT_FOLDER, this.fileDialog_.getFolder());
        }
        return bl;
    }

    private boolean openAsSave() {
        while (true) {
            this.createFileDialog();
            boolean bl = this.fileDialog_.chooseFile();
            if (!bl) {
                return bl;
            }
            this.context_.setAttribute(CURRENT_FOLDER, this.fileDialog_.getFolder());
            File file = this.fileDialog_.getFile();
            file = this.checkExtension(file);
            this.fileDialog_.setFile(file);
            if (!file.exists()) {
                return true;
            }
            if (file.isDirectory()) {
                MessageDialog.openInformation(this.fileDialog_.getParent(), NT_BAD_ASSIGN.get(), MSG_ASSIGN_NO_DIRECTORY.get((Object)this.fileDialog_.getFile().getAbsolutePath()));
                continue;
            }
            if (!file.canWrite()) {
                MessageDialog.openInformation(this.fileDialog_.getParent(), NT_BAD_ASSIGN.get(), MSG_ASSIGN_WRITABLE.get((Object)this.fileDialog_.getFile().getAbsolutePath()));
                continue;
            }
            MessageDialog messageDialog = new MessageDialog(this.fileDialog_.getParent(), NT_CONFIRM_OVERWRITE.get(), null, MSG_FILE_IS_EXISTS_OVERWRITE.get((Object)this.fileDialog_.getFile().getAbsolutePath()), 3, new String[]{CLB_OVERWRITE.get(), CLB_SAVE_ANOTHER_NAME.get()}, 1);
            if (messageDialog.open() == 0) break;
        }
        return true;
    }

    private File checkExtension(File file) {
        String string;
        File file2 = file;
        if (Yukinoshita.context(null).getAttribute(Context.APPEND_SGF_EXTENSION_IN_SAVE).booleanValue() && !(string = FilenameUtils.getExtension(file.getName())).equalsIgnoreCase("sgf")) {
            file2 = new File(file.getAbsolutePath() + "." + "sgf");
        }
        return file2;
    }

    private void createFileDialog() {
        CurrentContext currentContext = Yukinoshita.context(null);
        FileDialogStyle fileDialogStyle = currentContext.getAttribute(FILE_DIALOG_STYLE);
        switch (fileDialogStyle) {
            case OS: {
                this.fileDialog_ = new SwtFileChooser(this.parent_, this.style_);
                break;
            }
            case ORIGINAL: {
                this.fileDialog_ = new ExplorerLikeFileChooser(this.parent_, this.style_);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.fileDialog_.setFileName(this.filename_);
        this.fileDialog_.setFolder(this.currentDirectory_);
        NamedFileFilter[] namedFileFilterArray = new NamedFileFilter[]{new NamedFileFilter(FILE_FILTER_SGF, NT_FILTER_SGF.get()), new NamedFileFilter(FILE_FILTER_ALL, NT_FILTER_ALL.get())};
        this.fileDialog_.setFilter(namedFileFilterArray);
        switch (this.style_) {
            case OPEN_FILE: {
                this.fileDialog_.setText(NT_FILE_OPEN.get());
                break;
            }
            case OPEN_FILES: {
                this.fileDialog_.setText(NT_FILE_OPEN_MULTI.get());
                break;
            }
            case SAVE_FILE: {
                this.fileDialog_.setText(NT_FILE_SAVE.get());
                break;
            }
            default: {
                throw new RuntimeException("Bad style:" + (Object)((Object)this.style_));
            }
        }
    }

    public File getFile() {
        return this.fileDialog_.getFile();
    }

    public File[] getFiles() {
        return this.fileDialog_.getFiles();
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        File file2 = file;
        while (!file2.isDirectory()) {
            this.filename_ = file2.getName();
            if ((file2 = file2.getParentFile()) != null) continue;
            return;
        }
        this.currentDirectory_ = file2;
    }
}

