/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.unitarou.jface.FontResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.swt.USashForm;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardOption;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardProvider;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

public class AsciiBoardDialog
extends Dialog {
    private static final Message LB_DIALOG_TITLE = new Message(AsciiBoardDialog.class, "lbDialogTitle");
    private static final Message LB_STYLE = new Message(AsciiBoardDialog.class, "lbStyle");
    private static final Message LB_OPTION = new Message(AsciiBoardDialog.class, "lbOption");
    private static final Message LB_FONT = new Message(AsciiBoardDialog.class, "lbFont");
    private static final Message LB_FONT_POINT = new Message(AsciiBoardDialog.class, "lbFontPoint");
    private static final Message CLB_CHANGE_FONT = new Message(AsciiBoardDialog.class, "clbChangeFont");
    private static final Message CLB_COPY_TO_CLIPBOARD = new Message(AsciiBoardDialog.class, "clbCopyToClipboard");
    private static final int COPY_ID = 1024;
    private static final IntContextValue DLG_HEIGHT = new IntContextValue(AsciiBoardDialog.class, "dlgHeight", 50, 480, 2048);
    private static final IntContextValue DLG_WIDTH = new IntContextValue(AsciiBoardDialog.class, "dlgWidgh", 50, 640, 2048);
    private static final IntContextValue CTL_WIDTH = new IntContextValue(AsciiBoardDialog.class, "ctlWidth", 10, 130, 2048);
    private final NodeView nodeView_;
    private Composite allFrame_;
    private Composite ctxFrame_;
    private Text asciiText_;
    private Combo styleCombo_;
    private final Map<AsciiBoardOption, Button> optionButtonMap_;
    private Label lbFontName_;
    private Label lbFontSize_;
    private final AsciiBoardProvider[] providers_;

    public AsciiBoardDialog(Shell shell, NodeView nodeView) {
        super(shell);
        ArgumentChecker.throwIfNull((Object)nodeView);
        this.nodeView_ = nodeView;
        this.optionButtonMap_ = new HashMap<AsciiBoardOption, Button>();
        this.providers_ = (AsciiBoardProvider[])Yukinoshita.context().getProviders(AsciiBoardProvider.class);
        this.setShellStyle(65584);
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(LB_DIALOG_TITLE.get());
        CurrentContext currentContext = Yukinoshita.context(null);
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.widthHint = currentContext.getInteger(DLG_WIDTH);
        gridData.heightHint = currentContext.getInteger(DLG_HEIGHT);
        this.allFrame_ = composite;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        USashForm uSashForm = SwtFactory.createUSashForm(composite2, 256);
        uSashForm.setLayoutData(new GridData(4, 4, true, true));
        this.asciiText_ = new Text((Composite)uSashForm, 2818);
        this.createControlArea(uSashForm);
        uSashForm.setWeights(new int[]{100, -currentContext.getInteger(CTL_WIDTH)});
        this.updateController();
        return composite2;
    }

    private void createControlArea(Composite composite) {
        this.ctxFrame_ = new Composite(composite, 0);
        this.ctxFrame_.setLayout((Layout)SwtFactory.createGrid(1, true));
        this.createStyleControler(this.ctxFrame_);
        this.createOptionController(this.ctxFrame_);
        this.createFontController(this.ctxFrame_);
    }

    private void createStyleControler(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(LB_STYLE.get());
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.styleCombo_ = new Combo(composite, 12);
        AsciiBoardProvider asciiBoardProvider = Yukinoshita.context(null).getProvider(AsciiBoardProvider.class);
        for (AsciiBoardProvider asciiBoardProvider2 : this.providers_) {
            this.styleCombo_.add(asciiBoardProvider2.displayName());
            if (!asciiBoardProvider.getClass().equals(asciiBoardProvider2.getClass())) continue;
            this.styleCombo_.select(this.styleCombo_.getItemCount() - 1);
        }
        this.styleCombo_.setLayoutData((Object)new GridData(4, 128, true, false));
        this.styleCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AsciiBoardDialog.this.updateController();
            }
        });
    }

    private void updateController() {
        if (this.styleCombo_.getSelectionIndex() == -1) {
            return;
        }
        AsciiBoardProvider asciiBoardProvider = this.providers_[this.styleCombo_.getSelectionIndex()];
        Yukinoshita.context(null).setProvider(AsciiBoardProvider.class, asciiBoardProvider);
        EnumSet<AsciiBoardOption> enumSet = asciiBoardProvider.getOptions();
        for (AsciiBoardOption object2 : EnumSet.allOf(AsciiBoardOption.class)) {
            Button button = this.optionButtonMap_.get((Object)object2);
            if (asciiBoardProvider.isSupported(object2)) {
                button.setEnabled(true);
                button.setSelection(enumSet.contains((Object)object2));
                continue;
            }
            button.setEnabled(false);
            button.setSelection(false);
        }
        FontData fontData = asciiBoardProvider.getFontData();
        this.lbFontName_.setText(fontData.getName());
        this.lbFontSize_.setText(LB_FONT_POINT.get((Object)fontData.getHeight()));
        this.lbFontSize_.getParent().layout();
        FontResource fontResource = new FontResource(fontData);
        this.asciiText_.setFont(fontResource.get());
        this.updateText();
    }

    private void updateText() {
        if (this.styleCombo_.getSelectionIndex() == -1) {
            return;
        }
        AsciiBoardProvider asciiBoardProvider = this.providers_[this.styleCombo_.getSelectionIndex()];
        this.asciiText_.setText(((Object)asciiBoardProvider.getAsciiBoard(this.nodeView_)).toString());
    }

    private void createOptionController(Composite composite) {
        Group group = SwtFactory.createGroup(composite, 0);
        group.setLayout((Layout)SwtFactory.createGrid(1, true));
        group.setText(LB_OPTION.get());
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                AsciiBoardOption asciiBoardOption = (AsciiBoardOption)((Object)button.getData());
                AsciiBoardProvider asciiBoardProvider = AsciiBoardDialog.this.providers_[AsciiBoardDialog.this.styleCombo_.getSelectionIndex()];
                EnumSet<AsciiBoardOption> enumSet = asciiBoardProvider.getOptions();
                if (button.getSelection()) {
                    enumSet.add(asciiBoardOption);
                } else {
                    enumSet.remove((Object)asciiBoardOption);
                }
                asciiBoardProvider.setOptions(enumSet);
                AsciiBoardDialog.this.updateController();
            }
        };
        for (AsciiBoardOption asciiBoardOption : EnumSet.allOf(AsciiBoardOption.class)) {
            Button button = SwtFactory.createCheckButton((Composite)group, 0);
            button.setText(asciiBoardOption.toString());
            button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            button.setData((Object)asciiBoardOption);
            button.addSelectionListener((SelectionListener)selectionAdapter);
            this.optionButtonMap_.put(asciiBoardOption, button);
        }
    }

    private void createFontController(Composite composite) {
        Group group = SwtFactory.createGroup(composite, 0);
        group.setLayout((Layout)SwtFactory.createGrid(1, true));
        group.setText(LB_FONT.get());
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lbFontName_ = new Label((Composite)group, 0);
        this.lbFontName_.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lbFontSize_ = new Label((Composite)group, 0);
        this.lbFontSize_.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Button button = new Button((Composite)group, 8);
        button.setText(CLB_CHANGE_FONT.get());
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontDialog fontDialog = new FontDialog(AsciiBoardDialog.this.getShell());
                fontDialog.setFontList(AsciiBoardDialog.this.asciiText_.getFont().getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                AsciiBoardProvider asciiBoardProvider = AsciiBoardDialog.this.providers_[AsciiBoardDialog.this.styleCombo_.getSelectionIndex()];
                asciiBoardProvider.setFontData(fontData);
                AsciiBoardDialog.this.updateText();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1024, CLB_COPY_TO_CLIPBOARD.get(), false);
        this.createButton(composite, 12, BasicMessages.CLB_CLOSE.get(), true);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 1024: {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{this.asciiText_.getText()}, new Transfer[]{textTransfer});
                break;
            }
            case 12: {
                CurrentContext currentContext = Yukinoshita.context(null);
                currentContext.setInteger(DLG_HEIGHT.id(), this.allFrame_.getSize().y);
                currentContext.setInteger(DLG_WIDTH.id(), this.allFrame_.getSize().x);
                currentContext.setInteger(CTL_WIDTH.id(), this.ctxFrame_.getSize().x);
                this.cancelPressed();
            }
        }
    }
}

