/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.swt.UOwnerDrawTable;
import org.unitarou.swt.UOwnerDrawTableProvider;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Units;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.db.Dataset;
import org.unitarou.yukinoshita.view.jface.db.TiSearchedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchedFilePanel
implements WidgetContainer {
    private static Log log_s_ = LogFactory.getLog(SearchedFilePanel.class);
    private static final Message LB_NOW_SEARCHING = new Message(SearchedFilePanel.class, "lbNowSearching");
    private static final Message LB_SEARCH_STATISTIC = new Message(SearchedFilePanel.class, "lbSearchStatistic");
    private Composite frame_;
    private Label lbStatus_;
    private final StackLayout stackLayout_;
    private final UTable<TiSearchedFile> table_;
    private UOwnerDrawTable<TiSearchedFile> thumbnail_;

    public SearchedFilePanel(UTableProvider<TiSearchedFile> uTableProvider, UOwnerDrawTableProvider<TiSearchedFile> uOwnerDrawTableProvider) {
        ArgumentChecker.throwIfNull(uTableProvider);
        this.stackLayout_ = new StackLayout();
        this.table_ = new UTable<TiSearchedFile>(uTableProvider, Collections.emptyList(), 65568);
        this.thumbnail_ = new UOwnerDrawTable<TiSearchedFile>(uOwnerDrawTableProvider, (Collection<TiSearchedFile>)Collections.emptyList(), 32);
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout((Layout)new GridLayout(1, false));
        Control control = this.createStatusArea(this.frame_);
        control.setLayoutData((Object)new GridData(4, 1024, true, false));
        control = this.createResultArea(this.frame_);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        TableChekcListener tableChekcListener = new TableChekcListener();
        Table table = this.table_.getControl();
        table.addSelectionListener((SelectionListener)tableChekcListener);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TiSearchedFile tiSearchedFile = (TiSearchedFile)SearchedFilePanel.this.getPointedItem(SearchedFilePanel.this.table_, mouseEvent);
                SearchedFilePanel.this.addCollection(tiSearchedFile);
            }
        });
        table = this.thumbnail_.getControl();
        table.addSelectionListener((SelectionListener)tableChekcListener);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TiSearchedFile tiSearchedFile = (TiSearchedFile)SearchedFilePanel.this.getPointedItem(SearchedFilePanel.this.thumbnail_, mouseEvent);
                SearchedFilePanel.this.addCollection(tiSearchedFile);
            }
        });
        return this.frame_;
    }

    private <T> T getPointedItem(UTable<T> uTable, MouseEvent mouseEvent) {
        Table table = uTable.getControl();
        TableItem tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
        if (tableItem == null) {
            return null;
        }
        int n = table.indexOf(tableItem);
        assert (0 <= n) : "INVALID INDEX: " + n;
        return uTable.getRecords().get(n);
    }

    private void addCollection(TiSearchedFile tiSearchedFile) {
        if (tiSearchedFile == null) {
            return;
        }
        Shell shell = this.frame_.getShell();
        Application application = Yukinoshita.application();
        WindowController windowController = application.getWindowController(shell);
        if (windowController == null) {
            log_s_.log(LogLevel.WARN, "Can''t find WindowController. Hint is {0}", shell);
            return;
        }
        org.unitarou.sgf.Collection collection = FileManager.instance().open(new File(tiSearchedFile.getPath()));
        if (collection == null) {
            return;
        }
        windowController.registerCollection(collection, null, false, tiSearchedFile.getFileOrder());
    }

    private Control createStatusArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.lbStatus_ = new Label(composite2, 0);
        return composite2;
    }

    public void changeStyle(Dataset.ViewStyle viewStyle) {
        ArgumentChecker.throwIfNull((Object)viewStyle);
        switch (viewStyle) {
            case TABLE: {
                this.stackLayout_.topControl = this.table_.getControl();
                break;
            }
            case THUMBNAIL: {
                this.stackLayout_.topControl = this.thumbnail_.getControl();
            }
        }
        this.stackLayout_.topControl.getParent().layout();
    }

    private Control createResultArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.stackLayout_);
        this.table_.createContents(composite2);
        this.table_.getControl().setLinesVisible(true);
        this.table_.packColumns();
        this.thumbnail_.createContents(composite2);
        this.thumbnail_.getControl().setLinesVisible(true);
        this.thumbnail_.packColumns();
        this.stackLayout_.topControl = this.table_.getControl();
        return composite2;
    }

    public void notifyStartSearch() {
        this.lbStatus_.setText(LB_NOW_SEARCHING.get());
        this.lbStatus_.getParent().layout();
        this.table_.clear();
        this.thumbnail_.clear();
        this.stackLayout_.topControl.update();
    }

    public void setDataset(Collection<TiSearchedFile> collection, long l) {
        this.table_.clear();
        this.table_.addAll(collection);
        this.table_.extendColumns();
        this.thumbnail_.clear();
        this.thumbnail_.addAll(collection);
        this.thumbnail_.extendColumns();
        this.lbStatus_.setText(LB_SEARCH_STATISTIC.get(collection.size(), new Double(Units.toSecond(l))));
        this.lbStatus_.getParent().layout();
    }

    public List<TiSearchedFile> getSelected() {
        List<TiSearchedFile> list = this.stackLayout_.topControl == this.table_.getControl() ? this.table_.getRecords() : this.thumbnail_.getRecords();
        ArrayList<TiSearchedFile> arrayList = new ArrayList<TiSearchedFile>();
        for (TiSearchedFile tiSearchedFile : list) {
            if (!tiSearchedFile.isChecked()) continue;
            arrayList.add(tiSearchedFile);
        }
        return arrayList;
    }

    private class TableChekcListener
    extends SelectionAdapter {
        private TableChekcListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.detail != 32) {
                return;
            }
            TableItem tableItem = (TableItem)selectionEvent.item;
            if (((SearchedFilePanel)SearchedFilePanel.this).stackLayout_.topControl == SearchedFilePanel.this.table_.getControl()) {
                int n = SearchedFilePanel.this.table_.getControl().indexOf(tableItem);
                TiSearchedFile tiSearchedFile = (TiSearchedFile)SearchedFilePanel.this.table_.getRecords().get(n);
                tiSearchedFile.setChecked(tableItem.getChecked());
            } else {
                int n = SearchedFilePanel.this.thumbnail_.getControl().indexOf((TableItem)selectionEvent.item);
                TiSearchedFile tiSearchedFile = (TiSearchedFile)SearchedFilePanel.this.thumbnail_.getRecords().get(n);
                tiSearchedFile.setChecked(tableItem.getChecked());
            }
        }
    }
}

