/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.filter.RotationMirrorFilter;
import org.unitarou.sgf.util.filter.RotationMirrorFilters;

public class MoveQuery {
    private String[] patterns_ = Strings.EMPTY_ARRAY;
    private int offset_ = 0;
    private boolean isEnabled_ = false;

    public boolean isEnabled() {
        return this.isEnabled_;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled_ = bl;
    }

    public void setQuery(RootGameTree rootGameTree, int n) {
        RotationMirrorFilter[] rotationMirrorFilterArray = RotationMirrorFilter.values();
        this.patterns_ = new String[rotationMirrorFilterArray.length];
        for (int i = 0; i < rotationMirrorFilterArray.length; ++i) {
            RootGameTree rootGameTree2 = new RootGameTree(rootGameTree);
            RotationMirrorFilters.doFilter(rootGameTree2, rotationMirrorFilterArray[i]);
            this.patterns_[i] = this.toProcedure(rootGameTree2);
        }
        this.offset_ = n;
    }

    private String toProcedure(RootGameTree rootGameTree) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : rootGameTree.getSequence()) {
            Property property = node.getProperty(SgfId.BLACK);
            if (property != null) {
                stringBuilder.append(property.getString());
            }
            if ((property = node.getProperty(SgfId.WHITE)) == null) continue;
            stringBuilder.append(property.getString());
        }
        return stringBuilder.toString();
    }

    public String[] getQuery() {
        String[] stringArray = new String[this.patterns_.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.patterns_[i].length() < this.offset_ * 2 ? "" : this.patterns_[i].substring(this.offset_ * 2);
        }
        return stringArray;
    }

    public String[] getAllQuery() {
        String[] stringArray = new String[this.patterns_.length];
        System.arraycopy(this.patterns_, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public int getLength() {
        if (this.patterns_.length == 0) {
            return 0;
        }
        return this.patterns_[0].length() / 2;
    }

    public int getOffset() {
        return this.offset_;
    }
}

