/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.ml.Message;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColumnType {
    PATH,
    FOLDER,
    FILE_NAME,
    FILE_INDEX,
    GAME_TYPE,
    PLAYER,
    MOVES,
    DATE,
    FINGERPRINT,
    SGF_BLACK_RANK(SgfId.BLACK_RANK),
    SGF_EVENT(SgfId.EVENT),
    SGF_GAME_COMMENT(SgfId.GAME_COMMENT),
    SGF_GAME_NAME(SgfId.GAME_NAME),
    SGF_HANDICAP(SgfId.HANDICAP),
    SGF_KOMI(SgfId.KOMI),
    SGF_OVERTIME(SgfId.OVERTIME),
    SGF_PLAYER_BLACK(SgfId.PLAYER_BLACK),
    SGF_PLACE(SgfId.PLACE),
    SGF_PLAYER_WHITE(SgfId.PLAYER_WHITE),
    SGF_RESULT(SgfId.RESULT),
    SGF_ROUND(SgfId.ROUND),
    SGF_RULE(SgfId.RULE),
    SGF_SOURCE(SgfId.SOURCE),
    SGF_TIMELIMIT(SgfId.TIMELIMIT),
    SGF_USER(SgfId.USER),
    SGF_WHITE_RANK(SgfId.WHITE_RANK);

    private static final Message LB_FILE_PATH;
    private static final Message LB_FOLDER;
    private static final Message LB_FILE;
    private static final Message LB_FILE_INDEX;
    private static final Message LB_PLAYER;
    private static final Message LB_MOVES;
    private final SgfId sgfId_;

    private ColumnType() {
        this.sgfId_ = null;
    }

    private ColumnType(SgfId sgfId) {
        this.sgfId_ = sgfId;
    }

    SgfId getSgfId() {
        return this.sgfId_;
    }

    public String getString(SearchedFile searchedFile, List<Term> list) {
        if (this.sgfId_ != null) {
            for (Term object : list) {
                if (!this.sgfId_.id().equals(object.getSgfId())) continue;
                return object.getTerm();
            }
        }
        switch (this) {
            case PATH: {
                return searchedFile.getPath();
            }
            case FOLDER: {
                return FilenameUtils.getFullPath(searchedFile.getPath());
            }
            case FILE_NAME: {
                return FilenameUtils.getName(searchedFile.getPath());
            }
            case FILE_INDEX: {
                return Integer.toString(searchedFile.getFileOrder());
            }
            case GAME_TYPE: {
                return GameType.parseQuietly(GameType.GAME, searchedFile.getGameType()).displayName();
            }
            case MOVES: {
                return Integer.toString(searchedFile.getMove());
            }
            case DATE: {
                String string = searchedFile.getDate();
                if (string != null) {
                    return string;
                }
                for (Term term : list) {
                    if (!SgfId.DATE.id().equals(term.getSgfId())) continue;
                    return term.getTerm();
                }
                break;
            }
        }
        return "";
    }

    public String toString() {
        if (this.sgfId_ != null) {
            return this.sgfId_.displayName();
        }
        switch (this) {
            case PATH: {
                return LB_FILE_PATH.get();
            }
            case FOLDER: {
                return LB_FOLDER.get();
            }
            case FILE_NAME: {
                return LB_FILE.get();
            }
            case FILE_INDEX: {
                return LB_FILE_INDEX.get();
            }
            case GAME_TYPE: {
                return SgfId.GAME_TYPE.displayName();
            }
            case PLAYER: {
                return LB_PLAYER.get();
            }
            case MOVES: {
                return LB_MOVES.get();
            }
            case DATE: {
                return SgfId.DATE.displayName();
            }
        }
        return "";
    }

    static {
        LB_FILE_PATH = new Message(ColumnType.class, "lbFilePath");
        LB_FOLDER = new Message(ColumnType.class, "lbFolder");
        LB_FILE = new Message(ColumnType.class, "lbFiler");
        LB_FILE_INDEX = new Message(ColumnType.class, "lbFileIndex");
        LB_PLAYER = new Message(ColumnType.class, "lbPlayer");
        LB_MOVES = new Message(ColumnType.class, "lbMoves");
    }
}

