/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.OverblockMarker;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.MarkPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.CirclePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.CrossPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.DimPointsPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.Painter;
import org.unitarou.yukinoshita.view.jface.board.mp.SelectedPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.SquarePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.TerritoryBlackPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.TerritoryWhitePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.TrianglePainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMarkerPainter
implements MarkPainter {
    private static final ColorResource COLOR_VARIATION_FONT = new ColorResource(0, 102, 0);
    private static final ColorResource COLOR_LINE = new ColorResource(0, 102, 0);
    private static final ColorResource COLOR_LINE_NOGDI = new ColorResource(0, 153, 0);
    private static final ColorResource COLOR_LINE_NOGDI_TRANSIENT = new ColorResource(0, 255, 0);
    private static final FontResource FONT_VARIATION = new FontResource("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 24, 1);
    private static final FontResource FONT_LABEL = new FontResource("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 24, 1);
    private static final String ERROR_MARK = "!";
    private final SortedMap<SgfId, Painter> painterMap_ = new TreeMap<SgfId, Painter>();
    private final SgfId[] scope_;
    private final Set<SgfPoint> lastDd_;

    public SimpleMarkerPainter() {
        this.painterMap_.put(SgfId.MARK_WITH_X, new CrossPainter());
        this.painterMap_.put(SgfId.CIRCLE, new CirclePainter());
        this.painterMap_.put(SgfId.SQUARE, new SquarePainter());
        this.painterMap_.put(SgfId.TRIANGLE, new TrianglePainter());
        this.painterMap_.put(SgfId.SELECTED, new SelectedPainter());
        this.painterMap_.put(SgfId.TERRITORY_WHITE, new TerritoryWhitePainter());
        this.painterMap_.put(SgfId.TERRITORY_BLACK, new TerritoryBlackPainter());
        this.painterMap_.put(SgfId.DIM_POINTS, new DimPointsPainter());
        this.scope_ = this.painterMap_.keySet().toArray(new SgfId[this.painterMap_.size()]);
        this.lastDd_ = new HashSet<SgfPoint>();
    }

    @Override
    public SgfId[] markerScope() {
        SgfId[] sgfIdArray = new SgfId[this.scope_.length];
        System.arraycopy(this.scope_, 0, sgfIdArray, 0, sgfIdArray.length);
        return sgfIdArray;
    }

    @Override
    public void paintMark(GC gC, Rectangle rectangle, SgfId sgfId, boolean bl) {
        Painter painter = (Painter)this.painterMap_.get(sgfId);
        if (painter != null) {
            painter.paint(gC, rectangle, bl);
        }
    }

    @Override
    public void paintLine(GC gC, Rectangle rectangle, Rectangle rectangle2, SgfId sgfId, boolean bl) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)rectangle2, (Object)sgfId);
        if (!SgfId.LINE.equals(sgfId) && !SgfId.ARROW.equals(sgfId)) {
            return;
        }
        Point point = Geometry.centerPoint(rectangle);
        Point point2 = Geometry.centerPoint(rectangle2);
        gC.setAdvanced(true);
        if (!gC.getAdvanced()) {
            gC.setForeground(bl ? COLOR_LINE_NOGDI_TRANSIENT.get() : COLOR_LINE_NOGDI.get());
        } else {
            gC.setAntialias(1);
            gC.setAlpha(bl ? 48 : 255);
            gC.setForeground(COLOR_LINE.get());
        }
        gC.setLineWidth(3);
        gC.drawLine(point.x, point.y, point2.x, point2.y);
        if (sgfId.equals(SgfId.ARROW)) {
            double d = point.x == point2.x ? (double)Math.signum(point2.y - point.y) * Math.PI / 2.0 : Math.atan2(point2.y - point.y, point2.x - point.x);
            double d2 = d + 2.356194490192345;
            double d3 = d - 2.356194490192345;
            double d4 = (double)rectangle.width / 4.0;
            Point point3 = new Point((int)((double)point2.x + Math.cos(d2) * d4), (int)((double)point2.y + Math.sin(d2) * d4));
            Point point4 = new Point((int)((double)point2.x + Math.cos(d3) * d4), (int)((double)point2.y + Math.sin(d3) * d4));
            gC.drawLine(point2.x, point2.y, point3.x, point3.y);
            gC.drawLine(point2.x, point2.y, point4.x, point4.y);
        }
    }

    @Override
    public void paintLabel(GC gC, Rectangle rectangle, Label label, boolean bl) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)label);
        gC.setFont(FONT_LABEL.get((int)((double)rectangle.height / 1.41)));
        Point point = gC.textExtent(label.getLabel().getText());
        int n = rectangle.x + rectangle.width / 2 - point.x / 2;
        int n2 = rectangle.y + rectangle.height / 2 - point.y / 2;
        gC.setForeground(Display.getCurrent().getSystemColor(bl ? 13 : 9));
        gC.drawText(label.getLabel().getText(), n, n2, true);
    }

    @Override
    public void paintVariation(GC gC, Rectangle rectangle, String[] stringArray) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)stringArray);
        int n = stringArray.length <= 1 ? 1 : (stringArray.length <= 4 ? 2 : (stringArray.length <= 9 ? 3 : 4));
        Point point = Geometry.divide(Geometry.getSize(rectangle), n);
        int n2 = rectangle.width / (n * 2);
        for (int i = 0; i < Math.min(stringArray.length, 16); ++i) {
            String string = stringArray[i];
            gC.setFont(n == 1 ? FONT_VARIATION.getInCircle(gC, string, point.x) : FONT_VARIATION.getInRect(gC, string, point));
            Point point2 = gC.textExtent(string);
            gC.setForeground(COLOR_VARIATION_FONT.get());
            gC.drawText(string, rectangle.x + n2 + point.x * (i % n) - point2.x / 2, rectangle.y + n2 + point.y * (i / n) - point2.y / 2, true);
        }
    }

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        hashSet.addAll(this.lastDd_);
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>();
        InheritableMarker inheritableMarker = nodeView.getInheritableMarker();
        this.appendInheritable(treeSet, inheritableMarker, SgfId.DIM_POINTS, nodeView.getSize());
        hashSet.addAll(treeSet);
        this.lastDd_.retainAll(treeSet);
        hashSet.removeAll(this.lastDd_);
        this.lastDd_.addAll(treeSet);
        return hashSet;
    }

    private void appendInheritable(Set<SgfPoint> set, InheritableMarker inheritableMarker, SgfId sgfId, SgfSize sgfSize) {
        String[] stringArray = inheritableMarker.get(sgfId);
        if (stringArray != null) {
            SgfPoint[] sgfPointArray;
            for (SgfPoint sgfPoint : sgfPointArray = SgfPoint.parse(sgfSize, stringArray)) {
                set.add(sgfPoint);
            }
        }
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        Object object;
        ArgumentChecker.throwIfNull((Object)nodeView);
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        this.calcLbLnArea(nodeView, hashSet);
        for (SgfId object2 : this.scope_) {
            SgfPoint[] sgfPointArray;
            if (object2.propertyType().equals(PropertyType.INHERIT) || (object = nodeView.getProperty(object2)) == null) continue;
            for (SgfPoint sgfPoint : sgfPointArray = SgfPoint.parse(nodeView.getSize(), ((Property)object).getStrings())) {
                hashSet.add(sgfPoint);
            }
        }
        for (NodeView nodeView2 : nodeView.getVariations()) {
            object = nodeView2.getMove().getPoint();
            if (object == null || SgfPointType.PASS.equals((Object)((SgfPoint)object).condition())) continue;
            hashSet.add((SgfPoint)object);
        }
        return hashSet;
    }

    private void calcLbLnArea(NodeView nodeView, Set<SgfPoint> set) {
        OverblockMarker overblockMarker = nodeView.getOverblockMarker();
        if (overblockMarker.isEmpty()) {
            return;
        }
        SgfSize sgfSize = nodeView.getSize();
        for (Label typedString : overblockMarker.getLabels(sgfSize)) {
            for (int i = 1; i <= sgfSize.width(); ++i) {
                set.add(SgfPoint.create(sgfSize, i, typedString.getPoint().y()));
            }
        }
        for (TypedString<Label> typedString : overblockMarker.getLine(SgfId.LINE, sgfSize)) {
            this.addLineArea((SgfLine)typedString, sgfSize, set);
        }
        for (TypedString<Label> typedString : overblockMarker.getLine(SgfId.ARROW, sgfSize)) {
            this.addLineArea((SgfLine)typedString, sgfSize, set);
        }
    }

    private void addLineArea(SgfLine sgfLine, SgfSize sgfSize, Set<SgfPoint> set) {
        int n = Math.min(sgfLine.getStart().x(), sgfLine.getEnd().x());
        int n2 = Math.max(sgfLine.getStart().x(), sgfLine.getEnd().x());
        int n3 = Math.min(sgfLine.getStart().y(), sgfLine.getEnd().y());
        int n4 = Math.max(sgfLine.getStart().y(), sgfLine.getEnd().y());
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                set.add(SgfPoint.create(sgfSize, i, j));
            }
        }
    }

    @Override
    public void paintStatus(GC gC, BlockStatus blockStatus) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)blockStatus);
        if (!blockStatus.getPointTypes().contains((Object)SgfPointType.OVERLAP)) {
            return;
        }
        Rectangle rectangle = blockStatus.getRectangle();
        gC.setFont(FONT_LABEL.get(rectangle.height / 2));
        Point point = gC.textExtent(ERROR_MARK);
        int n = rectangle.x + rectangle.width * 3 / 4 - point.x / 2;
        int n2 = rectangle.y + rectangle.height * 1 / 4 - point.y / 2;
        gC.setForeground(Display.getCurrent().getSystemColor(8));
        gC.drawText(ERROR_MARK, n, n2, true);
    }
}

