/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.bp;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.NamedImageResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrainBlockPainter
implements BoardPainter {
    private static final Message LB_DISPLAY_NAME = new Message(GrainBlockPainter.class, "lbDisplayName");
    private static final NamedImageResource[] PATTERNS = new NamedImageResource[]{new NamedImageResource(GrainBlockPainter.class, "Torreya_nucifera_1.png"), new NamedImageResource(GrainBlockPainter.class, "Torreya_nucifera_2.png"), new NamedImageResource(GrainBlockPainter.class, "Torreya_nucifera_3.png"), new NamedImageResource(GrainBlockPainter.class, "Cercidiphyllum_japonicum_1.png"), new NamedImageResource(GrainBlockPainter.class, "Cercidiphyllum_japonicum_2.png")};
    public static final IntContextValue PATTERN_INDEX = new IntContextValue(GrainBlockPainter.class, "patternIndex", 0, 0, PATTERNS.length);
    private int patternIndex_ = -1;
    private final String keyImage_ = GrainBlockPainter.class.getName() + Integer.toString(System.identityHashCode(this), 16);
    private final Map<Point, Reference<ImageData>> imageMap_ = new HashMap<Point, Reference<ImageData>>();

    public static NamedImageResource[] getTextures() {
        NamedImageResource[] namedImageResourceArray = new NamedImageResource[PATTERNS.length];
        System.arraycopy(PATTERNS, 0, namedImageResourceArray, 0, namedImageResourceArray.length);
        return namedImageResourceArray;
    }

    public static String getDisplayName() {
        return LB_DISPLAY_NAME.get();
    }

    @Override
    public boolean containsContextKey(Set<String> set) {
        return set.contains(PATTERN_INDEX.id());
    }

    @Override
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    @Override
    public void paint(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        SgfSize sgfSize = sgfPoint.size();
        Point point = new Point(sgfSize.width() * rectangle.width, sgfSize.height() * rectangle.height);
        Image image = this.getTexture(point);
        Rectangle rectangle2 = image.getBounds();
        int n = rectangle2.width / sgfPoint.size().width();
        int n2 = rectangle2.height / sgfPoint.size().height();
        int n3 = (sgfPoint.x() - 1) * n;
        int n4 = (sgfPoint.y() - 1) * n2;
        gC.drawImage(image, n3, n4, n, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Image getTexture(Point point) {
        CurrentContext currentContext = Yukinoshita.context(null);
        int n = currentContext.getInteger(PATTERN_INDEX);
        if (n < -1 || PATTERNS.length <= n) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        if (this.patternIndex_ != n) {
            this.imageMap_.clear();
        }
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        Image image = imageRegistry.get(this.keyImage_);
        if (this.patternIndex_ != n || image == null || !Geometry.getSize(image.getBounds()).equals((Object)point)) {
            this.patternIndex_ = n;
            image = this.createImage(point);
            imageRegistry.remove(this.keyImage_);
            imageRegistry.put(this.keyImage_, image);
        }
        return image;
    }

    private Image createImage(Point point) {
        ImageData imageData;
        Reference<ImageData> reference = this.imageMap_.get(point);
        if (reference != null && (imageData = reference.get()) != null) {
            return new Image((Device)Display.getCurrent(), imageData);
        }
        return this.createImageImpl(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createImageImpl(Point point) {
        Image image;
        GC gC = null;
        try {
            double d;
            Image image2 = PATTERNS[this.patternIndex_].get();
            Image image3 = new Image((Device)Display.getCurrent(), point.x, point.y);
            gC = new GC((Drawable)image3);
            Rectangle rectangle = image2.getBounds();
            if (point.x < point.y) {
                d = (double)point.x / (double)point.y;
                rectangle.width = (int)((double)rectangle.width * d);
            } else if (point.y < point.x) {
                d = (double)point.y / (double)point.x;
                rectangle.height = (int)((double)rectangle.height * d);
            }
            gC.drawImage(image2, 0, 0, rectangle.width, rectangle.height, 0, 0, point.x, point.y);
            this.imageMap_.put(point, new SoftReference<ImageData>(image3.getImageData()));
            image = image3;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC);
        return image;
    }

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        return BlockPainter.EMPTY_SET;
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        return BlockPainter.EMPTY_SET;
    }
}

