/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.ComboStyle;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.ann.AnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.EnumEditor;
import org.unitarou.yukinoshita.view.jface.ann.ResultEditor;
import org.unitarou.yukinoshita.view.jface.ann.UEnumHandicap;
import org.unitarou.yukinoshita.view.jface.ann.UEnumKomi;
import org.unitarou.yukinoshita.view.jface.ann.UEnumTime;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameAnnotationPanel
extends AnnotationPanel {
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private GameType gameType_;
    private ScrolledComposite scFrame_;
    private final Map<SgfId, Text> textMap_;
    private final Map<SgfId, EnumEditor<?>> enumEditorMap_;
    private final ResultEditor resultEditor_;
    private final Adapter adapter_;
    private final TextListener textListener_;
    private final ComboModifyListener comboModifyListener_;
    private final ResultModifyListener resultModifyListener_;
    private NodeView nodeView_;
    private boolean isEditMode_;

    public GameAnnotationPanel(GameType gameType) {
        this.gameType_ = gameType;
        ArgumentChecker.throwIfNull((Object)gameType);
        this.textMap_ = new HashMap<SgfId, Text>();
        this.enumEditorMap_ = new HashMap();
        this.resultEditor_ = new ResultEditor();
        this.adapter_ = new Adapter();
        this.textListener_ = new TextListener();
        this.comboModifyListener_ = new ComboModifyListener();
        this.resultModifyListener_ = new ResultModifyListener();
        this.isEditMode_ = false;
    }

    @Override
    protected EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        Composite composite2;
        this.scFrame_ = new ScrolledComposite(composite, 512);
        this.scFrame_.setExpandHorizontal(true);
        this.scFrame_.setExpandVertical(false);
        this.scFrame_.getVerticalBar().setIncrement(10);
        Swts.defeatMouseWheel((Widget)this.scFrame_);
        switch (this.gameType_) {
            case PROBLEM: {
                composite2 = this.createProblemContents((Composite)this.scFrame_);
                break;
            }
            case DRILL: {
                composite2 = this.createDrillContents((Composite)this.scFrame_);
                break;
            }
            default: {
                composite2 = this.createGameContents((Composite)this.scFrame_);
            }
        }
        composite2.pack();
        this.scFrame_.setContent((Control)composite2);
        this.scFrame_.setMinSize(composite2.getSize());
        this.adapter_.setEditMode(this.isEditMode_);
        this.updateImpl(this.nodeView_);
        return this.scFrame_;
    }

    @Override
    public void close() {
    }

    private Composite createGameContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.createSimpleTextEditor(composite2, SgfId.GAME_NAME);
        this.createTextEditor(composite2, SgfId.GAME_COMMENT);
        this.createSimpleTextEditor(composite2, SgfId.PLAYER_WHITE);
        this.createSimpleTextEditor(composite2, SgfId.WHITE_RANK);
        this.createSimpleTextEditor(composite2, SgfId.WHITE_TEAM);
        this.createSimpleTextEditor(composite2, SgfId.PLAYER_BLACK);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_RANK);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_TEAM);
        this.createEnumEditor(composite2, SgfId.HANDICAP, UEnumHandicap.class);
        this.createEnumEditor(composite2, SgfId.KOMI, UEnumKomi.class);
        this.createResultEditor(composite2);
        this.createSimpleTextEditor(composite2, SgfId.DATE);
        this.createSimpleTextEditor(composite2, SgfId.EVENT);
        this.createSimpleTextEditor(composite2, SgfId.ROUND);
        this.createSimpleTextEditor(composite2, SgfId.PLACE);
        this.createSimpleTextEditor(composite2, SgfId.RULE);
        this.createEnumEditor(composite2, SgfId.TIMELIMIT, UEnumTime.class);
        this.createSimpleTextEditor(composite2, SgfId.OVERTIME);
        this.createSimpleTextEditor(composite2, SgfId.USER);
        this.createSimpleTextEditor(composite2, SgfId.SOURCE);
        this.createSimpleTextEditor(composite2, SgfId.COPYRIGHT);
        this.createSimpleTextEditor(composite2, SgfId.ANNOTATION);
        this.createSimpleTextEditor(composite2, SgfId.OPENING);
        return composite2;
    }

    private Composite createProblemContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.createSimpleTextEditor(composite2, SgfId.GAME_NAME);
        this.createResultEditor(composite2);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_RANK);
        this.createEnumEditor(composite2, SgfId.TIMELIMIT, UEnumTime.class);
        this.createTextEditor(composite2, SgfId.GAME_COMMENT);
        this.createSimpleTextEditor(composite2, SgfId.DATE);
        this.createSimpleTextEditor(composite2, SgfId.SOURCE);
        this.createSimpleTextEditor(composite2, SgfId.USER);
        this.createSimpleTextEditor(composite2, SgfId.COPYRIGHT);
        return composite2;
    }

    private Composite createDrillContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.createSimpleTextEditor(composite2, SgfId.GAME_NAME);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_RANK);
        this.createTextEditor(composite2, SgfId.GAME_COMMENT);
        return composite2;
    }

    private Text createSimpleTextEditor(Composite composite, SgfId sgfId) {
        this.createLabel(composite, sgfId);
        Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.addFocusListener((FocusListener)this.textListener_);
        text.addModifyListener((ModifyListener)this.textListener_);
        text.setData((Object)sgfId);
        this.textMap_.put(sgfId, text);
        return text;
    }

    private void createTextEditor(Composite composite, SgfId sgfId) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true, 2, 5);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 131072);
        label.setText(sgfId.displayName(this.gameType_));
        gridData = new GridData(1, 1, false, false);
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite2, 2626);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = label.computeSize((int)-1, (int)-1).y * 10;
        text.setLayoutData((Object)gridData);
        text.addFocusListener((FocusListener)this.textListener_);
        text.addModifyListener((ModifyListener)this.textListener_);
        text.setData((Object)sgfId);
        this.textMap_.put(sgfId, text);
    }

    private void createEnumEditor(Composite composite, SgfId sgfId, Class<? extends UEnum> clazz) {
        this.createLabel(composite, sgfId);
        EnumEditor<? extends UEnum> enumEditor = EnumEditor.createUEnum(clazz, EnumSet.noneOf(ComboStyle.class));
        enumEditor.addModifyListener(this.comboModifyListener_);
        Combo combo = enumEditor.createContents(composite);
        combo.setData((Object)sgfId);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.enumEditorMap_.put(sgfId, enumEditor);
    }

    private void createResultEditor(Composite composite) {
        Label label = this.createLabel(composite, SgfId.RESULT);
        GridData gridData = (GridData)label.getLayoutData();
        gridData.verticalAlignment = 128;
        gridData.verticalIndent = 4;
        Control control = this.resultEditor_.createContents(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultEditor_.addModifyListener(this.resultModifyListener_);
    }

    private Label createLabel(Composite composite, SgfId sgfId) {
        Label label = new Label(composite, 131072);
        label.setText(sgfId.displayName(this.gameType_));
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        return label;
    }

    @Override
    public Control getControl() {
        return this.scFrame_;
    }

    private void updateImpl(NodeView nodeView) {
        if (this.scFrame_ == null || nodeView == null) {
            return;
        }
        this.setModelUpdateMode(true);
        this.updateText(nodeView);
        this.updateCombo(nodeView);
        this.updateResult(nodeView);
        this.setModelUpdateMode(false);
    }

    private void updateText(NodeView nodeView) {
        for (Map.Entry<SgfId, Text> entry : this.textMap_.entrySet()) {
            Property property = nodeView.findProperty(entry.getKey());
            String string = "";
            if (property != null) {
                string = property.getString();
            }
            if (string.equals(entry.getValue().getText())) continue;
            entry.getValue().setText(string);
        }
    }

    private void updateCombo(NodeView nodeView) {
        for (Map.Entry<SgfId, EnumEditor<?>> entry : this.enumEditorMap_.entrySet()) {
            Property property = nodeView.findProperty(entry.getKey());
            String string = property == null ? "" : property.getString();
            entry.getValue().setText(string);
        }
    }

    private void updateResult(NodeView nodeView) {
        if (this.resultEditor_.getControl() != null) {
            this.resultEditor_.setProperty(nodeView.findProperty(SgfId.RESULT));
        }
    }

    private class Adapter
    implements GameMonitor,
    GameInfoNodeMonitor,
    ControllerStatusMonitor,
    EventBrokerMonitor {
        private boolean panelIsShown_ = true;

        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            GameAnnotationPanel.this.eventBroker_.removeView(GameAnnotationPanel.this);
            GameAnnotationPanel.this.eventBroker_ = eventBroker;
            GameAnnotationPanel.this.eventBroker_.addView(GameAnnotationPanel.this);
        }

        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            this.panelIsShown_ = rgtProxy.getGameType().equals(GameAnnotationPanel.this.gameType_);
            if (!this.panelIsShown_) {
                return;
            }
            NodeView nodeView = rgtProxy.getCurrentNodeView();
            GameAnnotationPanel.this.nodeView_ = nodeView;
            GameAnnotationPanel.this.updateImpl(GameAnnotationPanel.this.nodeView_);
        }

        public void gameInfoChanged(NodeView nodeView) {
            if (!this.panelIsShown_) {
                return;
            }
            GameAnnotationPanel.this.nodeView_ = nodeView;
            GameAnnotationPanel.this.updateImpl(GameAnnotationPanel.this.nodeView_);
        }

        public void setEditMode(boolean bl) {
            GameAnnotationPanel.this.isEditMode_ = bl;
            for (Object object : GameAnnotationPanel.this.textMap_.values()) {
                object.setEditable(bl);
            }
            for (Object object : GameAnnotationPanel.this.enumEditorMap_.values()) {
                ((EnumEditor)object).getControl().setEnabled(bl);
            }
            GameAnnotationPanel.this.resultEditor_.setEditable(bl);
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }

    private class ResultModifyListener
    implements ModifyListener {
        private ResultModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            String string = GameAnnotationPanel.this.resultEditor_.getString();
            GameAnnotationPanel.this.updateProperty(string, SgfId.RESULT, GameAnnotationPanel.this.nodeView_);
        }
    }

    private class ComboModifyListener
    implements ModifyListener {
        private ComboModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            SgfId sgfId = (SgfId)modifyEvent.widget.getData();
            EnumEditor enumEditor = (EnumEditor)GameAnnotationPanel.this.enumEditorMap_.get(sgfId);
            String string = enumEditor.getString();
            GameAnnotationPanel.this.updateProperty(string, sgfId, GameAnnotationPanel.this.nodeView_);
        }
    }

    private class TextListener
    extends FocusAdapter
    implements ModifyListener {
        private final Map<Text, String> lastStringMap_ = new HashMap<Text, String>();

        private TextListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string;
            int n;
            Text text = (Text)modifyEvent.widget;
            String string2 = this.lastStringMap_.get(text);
            if (string2 == null) {
                string2 = "";
            }
            if ((n = Yukinoshita.context(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE)) <= Strings.calcDiffSize(string2, string = text.getText())) {
                this.update(text);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.update((Text)focusEvent.widget);
        }

        private void update(Text text) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            String string = text.getText();
            SgfId sgfId = (SgfId)text.getData();
            GameAnnotationPanel.this.updateProperty(string, sgfId, GameAnnotationPanel.this.nodeView_);
            this.lastStringMap_.put(text, string);
        }
    }
}

