/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.WindowControllerListener;
import org.unitarou.yukinoshita.view.cmd.UndoComamnd;
import org.unitarou.yukinoshita.view.jface.act.ContextListeningAction;
import org.unitarou.yukinoshita.view.monitor.CommandDriverDefaultMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoAction
extends ContextListeningAction
implements Adaptable,
Closeable {
    private static final Log log_s_ = LogFactory.getLog(UndoAction.class);
    private static final Message CLB_NAME = new Message(UndoAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();

    public UndoAction(WindowController windowController) {
        super(windowController);
        this.controller_.addListener(this.adapter_);
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    protected void attributeChanged(Set<String> set) {
        if (set.contains(CoordinatesLabelProvider.CONTEXT.id())) {
            this.adapter_.updateImpl();
        }
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String string) {
        this.setText(CLB_NAME.get((Object)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.log(LogLevel.WARN, "#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            shell.setEnabled(false);
            CollectionController collectionController = this.controller_.getActiveCollectionController();
            UndoComamnd undoComamnd = new UndoComamnd();
            collectionController.getEventBroker().executeCommand(undoComamnd);
            CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
            if (status.getExecutedCommand() instanceof NodeListCommand) {
                collectionController.updateByRedoUndo(((NodeListCommand)status.getExecutedCommand()).getInfluence());
            }
        }
        finally {
            shell.setEnabled(true);
        }
    }

    private class Adapter
    extends CommandDriverDefaultMonitor
    implements ControllerStatusMonitor,
    WindowControllerListener,
    GameMonitor {
        private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void commandExecuted(CommandDriver.Status status) {
            ArgumentChecker.throwIfNull((Object)status);
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController != null) {
                UndoAction.this.setEnabled(collectionController.isEditMode() && status.isUndoable());
                UndoAction.this.setCommandName(status.getUndoName());
            }
        }

        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(UndoAction.this);
            }
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            if (collectionController == null) {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
                return;
            }
            collectionController.getEventBroker().addView(UndoAction.this);
            CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
            UndoAction.this.setEnabled(collectionController.isEditMode() && status.isUndoable());
            UndoAction.this.setCommandName(status.getUndoName());
        }

        public void setEditMode(boolean bl) {
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController == null) {
                log_s_.log(LogLevel.WARN, "Lost GameFraemController (BUG)");
                return;
            }
            if (bl) {
                CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
                UndoAction.this.setEnabled(status.isUndoable());
                UndoAction.this.setCommandName(status.getRedoName());
            } else {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
            }
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        public void update(RgtProxy rgtProxy) {
            this.updateImpl();
        }

        private void updateImpl() {
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController != null) {
                CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
                UndoAction.this.setEnabled(collectionController.isEditMode() && status.isUndoable());
                UndoAction.this.setCommandName(status.getUndoName());
            } else {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
            }
        }
    }
}

