/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserOption;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;

public class OpenFromClipboard
extends AbstractAction {
    private static final Log log_s_ = LogFactory.getLog(OpenFromClipboard.class);
    private static final Message LB_CLIPBOARD = new Message(OpenFromClipboard.class, "lbClipboard");
    private static final Message NT_CLIPBOARD_READ_FAILURE = new Message(OpenFromClipboard.class, "ntClipboardReadFailure");
    private static final Message MSG_NO_TEXT_CONTENTS = new Message(OpenFromClipboard.class, "msgNoTextContents");
    private static final Message MSG_NO_CONTENTS = new Message(OpenFromClipboard.class, "msgNoContents");
    private static final Message MSG_SGF_PARSE_ERROR = new Message(OpenFromClipboard.class, "msgSgfParseError");

    public OpenFromClipboard(WindowController windowController) {
        super(windowController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Display display = Display.getCurrent();
        Control control = display.getFocusControl();
        log_s_.log(LogLevel.TRACE, "Target control: {0}", control);
        if (this.pasteToControl(control)) {
            return;
        }
        Clipboard clipboard = new Clipboard(display);
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            TransferData[] transferDataArray = clipboard.getAvailableTypes();
            for (int i = 0; i < transferDataArray.length; ++i) {
                if (!textTransfer.isSupportedType(transferDataArray[i])) continue;
                String string = (String)clipboard.getContents((Transfer)textTransfer);
                this.openFromClipboardImpl(string);
                return;
            }
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, NT_CLIPBOARD_READ_FAILURE.get(), MSG_NO_TEXT_CONTENTS.get());
        }
        catch (SgfParserException sgfParserException) {
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CLIPBOARD_READ_FAILURE.get(), MSG_SGF_PARSE_ERROR.get());
        }
        finally {
            clipboard.dispose();
        }
    }

    private boolean pasteToControl(Control control) {
        Text text;
        if (control == null) {
            return false;
        }
        if (control instanceof Text && (text = (Text)control).getEditable()) {
            text.paste();
            return true;
        }
        if (control instanceof Combo && 0 == ((text = (Combo)control).getStyle() & 8)) {
            text.paste();
            return true;
        }
        return false;
    }

    private void openFromClipboardImpl(String string) throws SgfParserException {
        CurrentContext currentContext = Yukinoshita.context(null);
        EnumSet<SgfParserOption> enumSet = currentContext.getAttribute(FileManager.PARSER_OPTIONS);
        SgfParser sgfParser = new SgfParser();
        sgfParser.setOptions(enumSet);
        Collection collection = sgfParser.parse(string);
        if (collection.size() == 0) {
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CLIPBOARD_READ_FAILURE.get(), MSG_NO_CONTENTS.get());
            return;
        }
        this.controller_.registerCollection(collection, LB_CLIPBOARD.get(), false, 0);
    }
}

