/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

public class OpenFileAction
extends Action {
    private static final Log log_s_ = LogFactory.getLog(OpenFileAction.class);
    public static final Message CLB_NAME = new Message(OpenFileAction.class, "clbName");
    private WindowController controller_ = null;

    public OpenFileAction() {
        this.setText(CLB_NAME.get());
        this.setId(CLB_NAME.getKey());
    }

    public OpenFileAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        this.controller_ = windowController;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.controller_ == null) {
            log_s_.log(LogLevel.WARN, "#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        IgoFileDialog igoFileDialog = new IgoFileDialog(shell, IgoFileChooser.Style.OPEN_FILES);
        igoFileDialog.open();
        try {
            Yukinoshita.application().setCursorType(Application.CursorType.WAIT);
            for (File file : igoFileDialog.getFiles()) {
                this.openFileImpl(file);
            }
        }
        finally {
            Yukinoshita.application().setCursorType(Application.CursorType.NONE);
        }
    }

    private void openFileImpl(File file) {
        Collection collection = FileManager.instance().open(file);
        if (collection == null) {
            return;
        }
        FileManager.instance().insertFileHistory(file);
        this.controller_.registerCollection(collection, null, false, 0);
    }
}

