/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.action.Action;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.NewDrillFileAction;
import org.unitarou.yukinoshita.view.jface.act.NewGameFileAction;
import org.unitarou.yukinoshita.view.jface.act.NewProblemFileAction;

public class NewRgtFromTemplate
extends Action {
    private final RootGameTree rgt_;
    private final WindowController controller_;

    public NewRgtFromTemplate(RootGameTree rootGameTree, WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)rootGameTree, (Object)windowController);
        this.rgt_ = rootGameTree;
        this.controller_ = windowController;
        this.setText();
    }

    private void setText() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.rgt_.getGameType()) {
            case GAME: {
                stringBuilder.append(BasicFinder.findDatum(this.rgt_.getSequence(), SgfId.EVENT)).append('/').append(BasicFinder.findDatum(this.rgt_.getSequence(), SgfId.GAME_NAME));
                break;
            }
            case PROBLEM: {
                stringBuilder.append(BasicFinder.findDatum(this.rgt_.getSequence(), SgfId.SOURCE)).append('/').append(BasicFinder.findDatum(this.rgt_.getSequence(), SgfId.GAME_NAME));
                break;
            }
            case DRILL: {
                stringBuilder.append(BasicFinder.findDatum(this.rgt_.getSequence(), SgfId.GAME_NAME));
            }
        }
        this.setText(stringBuilder.toString());
    }

    public void run() {
        switch (this.rgt_.getGameType()) {
            case GAME: {
                NewGameFileAction.execute(this.controller_, this.rgt_);
                break;
            }
            case PROBLEM: {
                NewProblemFileAction.execute(this.controller_, this.rgt_);
                break;
            }
            case DRILL: {
                NewDrillFileAction.execute(this.controller_, this.rgt_);
            }
        }
    }
}

