/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.ArrayList;
import java.util.Random;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.sound.SoundEffect;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.AbstractViewCommand;

public class MoveInProblemCommand
extends AbstractViewCommand {
    private static final Random random_s_ = new Random();
    private final SgfPoint point_;
    private final ProblemStatus currentStatus_;
    private ProblemStatus changeTo_;

    public MoveInProblemCommand(SgfPoint sgfPoint, ProblemStatus problemStatus) {
        ArgumentChecker.throwIfNull((Object)sgfPoint, (Object)problemStatus);
        this.point_ = sgfPoint;
        this.changeTo_ = this.currentStatus_ = problemStatus;
    }

    public void execute() {
        Object object;
        this.throwIfNotSetup();
        RgtProxy rgtProxy = this.getCollectionProxy().getActive();
        if (rgtProxy.getCurrentNodeIndex() == rgtProxy.getNodeList().size() - 1) {
            this.updateProblemState(ProblemStatus.MISTAKE);
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE_END);
            return;
        }
        if (this.selectPlayerMove(rgtProxy, this.point_)) {
            this.fireNodeViewerUpdate();
            this.updateProblemState(ProblemStatus.MISTAKE);
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE_END);
            return;
        }
        SgfColor sgfColor = rgtProxy.getCurrentNodeView().getMove().getColor();
        try {
            object = new StopWatch();
            this.fireNodeViewerUpdate();
            Thread.yield();
            long l = 200L - ((StopWatch)object).stop() / 1000000L;
            if (l < 0L) {
                l = 0L;
            }
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.selectOppositeMove(rgtProxy)) {
            this.fireNodeViewerUpdate();
            object = rgtProxy.getCurrentNodeView();
            this.evaluateMove((NodeView)object);
        }
        if (!rgtProxy.getCurrentNodeView().isLast()) {
            return;
        }
        if (this.isInMainPath(rgtProxy)) {
            this.updateProblemState(ProblemStatus.CORRECT);
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE_END);
            return;
        }
        object = rgtProxy.getCurrentNodeView();
        ProblemStatus problemStatus = this.judge((NodeView)object, sgfColor);
        this.updateProblemState(problemStatus);
        this.fireHandlerPhaseChange(HandlerPhase.SOLVE_END);
    }

    private void updateProblemState(ProblemStatus problemStatus) {
        if (this.changeTo_ == problemStatus) {
            return;
        }
        this.changeTo_ = problemStatus;
        this.fireProblemStatusUpdate(problemStatus);
        switch (problemStatus) {
            case CORRECT: {
                SoundEffect.CORRECT.play();
                break;
            }
            case ONE_STEP_SHORT: {
                SoundEffect.ONE_STEP_SHORT.play();
                break;
            }
            case MISTAKE: {
                SoundEffect.MISTAKE.play();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private boolean selectPlayerMove(RgtProxy rgtProxy, SgfPoint sgfPoint) {
        NodeView nodeView = rgtProxy.getCurrentNodeView();
        this.evaluateMove(nodeView);
        if (nodeView.isChildrenStyle()) {
            boolean bl = this.selectPlayerMoveByVariation(rgtProxy, sgfPoint, true);
            NodeView nodeView2 = rgtProxy.setNodeIndexDelta(1);
            if (bl) {
                return false;
            }
            if (this.selectMove(rgtProxy, nodeView2, sgfPoint)) {
                return false;
            }
            rgtProxy.setNodeIndexDelta(-1);
            rgtProxy.executeCommand(new AddVariation(nodeView2.getMove().getColor(), sgfPoint));
            rgtProxy.setNodeIndexDelta(1);
            return true;
        }
        NodeView nodeView3 = rgtProxy.setNodeIndexDelta(1);
        if (this.selectPlayerMoveByVariation(rgtProxy, sgfPoint, false)) {
            return false;
        }
        if (this.selectMove(rgtProxy, nodeView3, sgfPoint)) {
            return false;
        }
        rgtProxy.setNodeIndexDelta(-1);
        rgtProxy.executeCommand(new AddVariation(nodeView3.getMove().getColor(), sgfPoint));
        return false;
    }

    private void evaluateMove(NodeView nodeView) {
        SgfDouble sgfDouble;
        SgfColor sgfColor = nodeView.getRootView().firstMove();
        if (sgfColor == null) {
            return;
        }
        Property property = nodeView.getProperty(sgfColor.situationType());
        if (property != null && (sgfDouble = SgfDouble.parseQuietly(property.getString())) != null) {
            switch (sgfDouble) {
                case NORMAL: {
                    this.updateProblemState(ProblemStatus.ONE_STEP_SHORT);
                    break;
                }
                case EMPHASIZED: {
                    this.updateProblemState(ProblemStatus.CORRECT);
                }
            }
        }
        if ((property = nodeView.getProperty(sgfColor.opposite().situationType())) == null) {
            return;
        }
        this.updateProblemState(ProblemStatus.MISTAKE);
    }

    private boolean selectPlayerMoveByVariation(RgtProxy rgtProxy, SgfPoint sgfPoint, boolean bl) {
        NodeView nodeView = rgtProxy.getCurrentNodeView();
        NodeView[] nodeViewArray = nodeView.getVariations();
        if (nodeViewArray.length == 0) {
            return false;
        }
        int n = -1;
        Stone stone = null;
        for (int i = 0; i < nodeViewArray.length; ++i) {
            stone = nodeViewArray[i].getMove();
            SgfPoint sgfPoint2 = stone.getPoint();
            if (n == -1 && sgfPoint2 != null && sgfPoint2.condition().equals((Object)SgfPointType.PASS)) {
                n = i;
                continue;
            }
            if (!sgfPoint.equals(sgfPoint2)) continue;
            rgtProxy.executeCommand(new SelectVariation(i));
            return true;
        }
        if (n == -1 || stone == null) {
            return false;
        }
        rgtProxy.executeCommand(new SelectVariation(n));
        SgfId sgfId = stone.getColor().moveType();
        if (bl) {
            rgtProxy.setNodeIndexDelta(1);
        }
        rgtProxy.executeCommand(new UpdateProperty(null, new Property(sgfId, sgfPoint.getString()), new Property[0]));
        if (bl) {
            rgtProxy.setNodeIndexDelta(-1);
        }
        return true;
    }

    private boolean selectMove(RgtProxy rgtProxy, NodeView nodeView, SgfPoint sgfPoint) {
        Stone stone = nodeView.getMove();
        if (sgfPoint.equals(stone.getPoint())) {
            return true;
        }
        if (stone.getPoint().condition().equals((Object)SgfPointType.PASS)) {
            SgfId sgfId = nodeView.getMove().getColor().moveType();
            rgtProxy.executeCommand(new UpdateProperty(null, new Property(sgfId, sgfPoint.getString()), new Property[0]));
            return true;
        }
        return false;
    }

    private boolean selectOppositeMove(RgtProxy rgtProxy) {
        int n;
        NodeView nodeView = rgtProxy.getCurrentNodeView();
        if (nodeView.isLast()) {
            return false;
        }
        if (nodeView.isChildrenStyle()) {
            int n2;
            NodeView[] nodeViewArray = nodeView.getVariations();
            if (nodeViewArray.length != 0 && 0 <= (n2 = this.getOppositeVariationIndex(nodeViewArray))) {
                rgtProxy.executeCommand(new SelectVariation(n2));
            }
            rgtProxy.setNodeIndexDelta(1);
            return true;
        }
        rgtProxy.setNodeIndexDelta(1);
        NodeView[] nodeViewArray = rgtProxy.getCurrentNodeView().getVariations();
        if (nodeViewArray.length != 0 && 0 <= (n = this.getOppositeVariationIndex(nodeViewArray))) {
            rgtProxy.executeCommand(new SelectVariation(n));
        }
        return true;
    }

    private int getOppositeVariationIndex(NodeView[] nodeViewArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nodeViewArray.length);
        for (int i = 0; i < nodeViewArray.length; ++i) {
            Property property = nodeViewArray[i].getProperty(SgfId.BAD_MOVE);
            if (property != null) continue;
            arrayList.add(i);
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        return (Integer)arrayList.get(random_s_.nextInt(arrayList.size()));
    }

    private boolean isInMainPath(RgtProxy rgtProxy) {
        for (int i = rgtProxy.getCurrentNodeIndex(); 0 <= i; --i) {
            NodeView nodeView = rgtProxy.getNodeList().getNodeView(i);
            if (0 >= nodeView.getSelectedVariationIndex()) continue;
            return false;
        }
        return true;
    }

    private ProblemStatus judge(NodeView nodeView, SgfColor sgfColor) {
        Property property = null;
        if (SgfColor.BLACK.equals(sgfColor)) {
            property = nodeView.getProperty(SgfId.GOOD_FOR_BLACK);
        } else if (SgfColor.WHITE.equals(sgfColor)) {
            property = nodeView.getProperty(SgfId.GOOD_FOR_WHITE);
        }
        if (property != null) {
            SgfDouble sgfDouble = SgfDouble.parseQuietly(property.getString());
            if (SgfDouble.EMPHASIZED.equals(sgfDouble)) {
                return ProblemStatus.CORRECT;
            }
            if (SgfDouble.NORMAL.equals(sgfDouble)) {
                return ProblemStatus.ONE_STEP_SHORT;
            }
        }
        return ProblemStatus.MISTAKE;
    }
}

