/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.AbstractViewCommand;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

public class ChangeGameCommand
extends AbstractViewCommand {
    private final int gameIndex_;

    public ChangeGameCommand(int n) {
        ArgumentChecker.throwIfNegative(n);
        this.gameIndex_ = n;
    }

    public void execute() {
        this.throwIfNotSetup();
        boolean bl = this.isEditMode();
        RgtProxy rgtProxy = this.getCollectionProxy().getActive();
        GameType gameType = rgtProxy.getGameType();
        if (!bl && gameType.equals(GameType.PROBLEM)) {
            rgtProxy.endSolvingProblem();
        }
        this.getCollectionProxy().setActive(this.gameIndex_);
        RgtProxy rgtProxy2 = this.getCollectionProxy().getActive();
        GameType gameType2 = rgtProxy2.getGameType();
        if (!gameType.equals(gameType2)) {
            this.getEventBroker().connect(gameType2, bl);
        }
        if (!bl && gameType2.equals(GameType.PROBLEM)) {
            RgtProxy rgtProxy3 = this.getActiveRgtProxy();
            Set<String> set = rgtProxy3.startSolvingProblem();
            this.fireGameViewerUpdate();
            this.fireNodeViewerUpdate();
            Yukinoshita.context().fireAttributeChanged(set);
            for (ControllerStatusMonitor controllerStatusMonitor : this.getListeners(ControllerStatusMonitor.class)) {
                controllerStatusMonitor.changeHandlerPhase(HandlerPhase.SOLVE);
            }
        } else {
            this.fireGameViewerUpdate();
            this.fireNodeViewerUpdate();
        }
    }
}

