/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.Set;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.AbstractViewCommand;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

public class ChangeEditModeCommand
extends AbstractViewCommand {
    private static Log log_s_ = LogFactory.getLog(ChangeEditModeCommand.class);

    public ChangeEditModeCommand(boolean bl) {
        this.getParameter().setEditMode(bl);
    }

    public void execute() {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        CollectionProxy collectionProxy = this.getCollectionProxy();
        EventBroker eventBroker = this.getEventBroker();
        boolean bl = this.isEditMode();
        if (GameType.DRILL.equals(collectionProxy.getCollection().get(0).getGameType())) {
            this.editModeChangedInDrill();
        } else {
            RgtProxy rgtProxy = collectionProxy.getActive();
            eventBroker.connect(rgtProxy.getGameType(), bl);
            if (rgtProxy.getGameType().equals(GameType.PROBLEM)) {
                if (bl) {
                    Set<String> object = rgtProxy.endSolvingProblem();
                    this.fireNodeViewerUpdate();
                    Yukinoshita.context().fireAttributeChanged(object);
                } else {
                    this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
                }
            }
        }
        log_s_.log(LogLevel.TRACE, "{0} seconds for update.", stopWatch.lapSecond());
        for (ControllerStatusMonitor controllerStatusMonitor : eventBroker.getListeners(ControllerStatusMonitor.class)) {
            controllerStatusMonitor.setEditMode(bl);
        }
        log_s_.log(LogLevel.TRACE, "{0} seconds for ControllerStatusMonitor.setEditMode.", stopWatch.stopSecond());
    }

    private void editModeChangedInDrill() {
        CollectionProxy collectionProxy = this.getCollectionProxy();
        EventBroker eventBroker = this.getEventBroker();
        boolean bl = this.isEditMode();
        if (bl) {
            Set<String> set = collectionProxy.getActive().endSolvingProblem();
            collectionProxy.setActive(0);
            Collection collection = collectionProxy.getCollection();
            while (1 < collection.size()) {
                collection.remove(1);
            }
            eventBroker.connect(collectionProxy.getActive().getGameType(), bl);
            this.fireGameViewerUpdate();
            this.fireNodeViewerUpdate();
            Yukinoshita.context().fireAttributeChanged(set);
        } else {
            Collection collection = collectionProxy.getCollection();
            ViewerUtils.setupDriiRootDirectory(collection);
            CollectionRepository.instance().loadProblem(collection);
            collectionProxy.setActive(1);
            eventBroker.connect(collectionProxy.getActive().getGameType(), bl);
            this.fireCollectionMonitorUpdate();
            this.fireGameViewerUpdate();
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
        }
    }
}

