/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.Provider;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerImpl;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.view.CollectionFrame;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.TabController;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ViewCommand;
import org.unitarou.yukinoshita.view.cmd.WrapperCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionController
implements Adaptable,
TabController {
    private static final Log log_s_ = LogFactory.getLog(CollectionController.class);
    private final CollectionProxy collectionProxy_;
    private final ListenerAdapter listenerAdapter_;
    private final WindowController windowController_;
    private final CollectionFrame collectionFrame_;
    private final EventBrokerImpl eventBrokerImpl_;
    private boolean isEditMode_;
    private final List<Integer> indexFilter_;

    public CollectionController(Collection collection, WindowController windowController, CollectionFrame collectionFrame, boolean bl, int n) {
        this(collection, windowController, collectionFrame, bl, n, false);
    }

    public CollectionController(Collection collection, WindowController windowController, CollectionFrame collectionFrame, boolean bl, int n, boolean bl2) {
        ArgumentChecker.throwIfNull((Object)collection, (Object)windowController, (Object)collectionFrame);
        if (collection.size() == 0) {
            throw new IllegalArgumentException("collection must have one or more games.");
        }
        this.windowController_ = windowController;
        this.collectionProxy_ = new CollectionProxy(collection, bl);
        this.collectionProxy_.setActive(n);
        this.eventBrokerImpl_ = new EventBrokerImpl();
        this.isEditMode_ = bl2;
        this.collectionFrame_ = collectionFrame;
        this.collectionFrame_.setEventBroker(this.eventBrokerImpl_);
        if (this.collectionProxy_.isDrill()) {
            ViewerUtils.setupDriiRootDirectory(collection);
            CollectionRepository.instance().loadProblem(collection);
            if (1 < collection.size()) {
                this.collectionProxy_.setActive(1);
                if (!this.isEditMode_) {
                    this.collectionProxy_.getActive().startSolvingProblem();
                }
            }
            this.indexFilter_ = new ArrayList<Integer>(this.collectionProxy_.size());
            for (int i = 1; i < this.collectionProxy_.size(); ++i) {
                this.indexFilter_.add(i);
            }
        } else {
            RgtProxy rgtProxy = this.collectionProxy_.getActive();
            if (GameType.PROBLEM.equals(rgtProxy.getGameType()) && !this.isEditMode_) {
                rgtProxy.startSolvingProblem();
            }
            this.indexFilter_ = new ArrayList<Integer>(this.collectionProxy_.size());
            for (int i = 0; i < this.collectionProxy_.size(); ++i) {
                this.indexFilter_.add(i);
            }
        }
        this.listenerAdapter_ = new ListenerAdapter();
        this.eventBrokerImpl_.addController(this);
        this.eventBrokerImpl_.addView(this);
        this.fireCollectionMonitorUpdate();
        this.fireGameMonitorUpdate();
        this.fireNodeMonitorUpdate();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.listenerAdapter_.getClass())) {
            return this.listenerAdapter_;
        }
        return null;
    }

    public void shutdown() {
        this.collectionProxy_.dispose();
        this.collectionFrame_.close();
        this.eventBrokerImpl_.removeController(this);
        this.eventBrokerImpl_.dispose();
    }

    public WindowController getWindowController() {
        return this.windowController_;
    }

    public CollectionProxy getCollectionProxy() {
        return this.collectionProxy_;
    }

    public Collection getCollection() {
        return this.collectionProxy_.getCollection();
    }

    public boolean isChanged() {
        if (this.collectionProxy_.isRgtEdited()) {
            return true;
        }
        boolean[] blArray = this.collectionProxy_.getChangedFlags();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return true;
        }
        return false;
    }

    public void clearChangedFlag() {
        this.collectionProxy_.clearChangedFlags();
        this.fireNodeMonitorUpdate();
    }

    public boolean isEditMode() {
        return this.isEditMode_;
    }

    public void updateByRedoUndo(EnumSet<ModelInfluence> enumSet) {
        block8: for (ModelInfluence modelInfluence : enumSet) {
            switch (modelInfluence) {
                case COLLECTION: {
                    this.fireCollectionMonitorUpdate();
                    continue block8;
                }
                case ROOT_GAME_TREE: {
                    this.fireGameMonitorUpdate();
                    continue block8;
                }
                case NODE_PEVIOUS: {
                    this.fireGameMonitorUpdate();
                    continue block8;
                }
                case NODE_DOWNWARD: {
                    this.fireGameMonitorUpdate();
                    continue block8;
                }
                case NODE_CURRENT: {
                    continue block8;
                }
                case NODE_GAMEINFO: {
                    this.fireGameInfoNodeUpdate();
                    continue block8;
                }
            }
            assert (false) : "Unknown type:" + (Object)((Object)modelInfluence);
        }
        this.fireNodeMonitorUpdate();
    }

    public EventBroker getEventBroker() {
        return this.eventBrokerImpl_;
    }

    private void fireCollectionMonitorUpdate() {
        GameType gameType = this.collectionProxy_.getActive().getGameType();
        this.eventBrokerImpl_.connect(gameType, this.isEditMode_);
        for (CollectionMonitor collectionMonitor : this.eventBrokerImpl_.getListeners(CollectionMonitor.class)) {
            collectionMonitor.update(this.collectionProxy_);
        }
    }

    private void fireGameMonitorUpdate() {
        StopWatch stopWatch = new StopWatch();
        ViewerUtils.setupDriiRootDirectory(this.collectionProxy_.getCollection());
        RgtProxy rgtProxy = this.collectionProxy_.getActive();
        for (GameMonitor gameMonitor : this.eventBrokerImpl_.getListeners(GameMonitor.class)) {
            gameMonitor.update(rgtProxy);
            log_s_.log(LogLevel.TRACE, "{0} seconds for {1}", stopWatch.lapSecond(), gameMonitor);
        }
        log_s_.log(LogLevel.TRACE, "{0} seconds for fireGameViewerUpdate.", stopWatch.stopSecond());
    }

    private void fireNodeMonitorUpdate() {
        StopWatch stopWatch = new StopWatch();
        NodeView nodeView = this.collectionProxy_.getActive().getCurrentNodeView();
        for (NodeMonitor nodeMonitor : this.eventBrokerImpl_.getListeners(NodeMonitor.class)) {
            nodeMonitor.currentChanged(nodeView);
            log_s_.log(LogLevel.TRACE, "{0} seconds for {1}", stopWatch.lapSecond(), nodeMonitor);
        }
        log_s_.log(LogLevel.TRACE, "{0} seconds for fireNodeViewerUpdate.", stopWatch.stopSecond());
    }

    private void fireGameInfoNodeUpdate() {
        RgtProxy rgtProxy = this.collectionProxy_.getActive();
        int n = rgtProxy.findNodeView(PropertyType.GAME_INFO);
        if (n < 0) {
            n = 0;
        }
        NodeView nodeView = rgtProxy.getNodeList().getNodeView(n);
        for (GameInfoNodeMonitor gameInfoNodeMonitor : this.eventBrokerImpl_.getListeners(GameInfoNodeMonitor.class)) {
            gameInfoNodeMonitor.gameInfoChanged(nodeView);
        }
    }

    public <T extends Provider> void changeProvider(Class<T> clazz, Provider provider) {
        ArgumentChecker.throwIfNull(clazz, (Object)provider);
        RgtProxy rgtProxy = this.collectionProxy_.getActive();
        CurrentContext currentContext = rgtProxy.getContext();
        currentContext.setProvider(clazz, provider);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(clazz.getName());
        Set<String> set = Collections.unmodifiableSet(hashSet);
        Yukinoshita.context().fireAttributeChanged(set);
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        RgtProxy rgtProxy = this.collectionProxy_.getActive();
        CurrentContext currentContext = rgtProxy.getContext();
        return currentContext.getProvider(clazz);
    }

    public List<Integer> getIndexFilter() {
        return Collections.unmodifiableList(this.indexFilter_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerAdapter
    implements ActionListener,
    CollectionMonitor {
        private HandlerPhase currentStatus_ = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeCommand(NodeListCommand nodeListCommand) {
            ArgumentChecker.throwIfNull((Object)nodeListCommand);
            WrapperCommand wrapperCommand = new WrapperCommand(nodeListCommand);
            wrapperCommand.getParameter().set(CollectionController.this);
            wrapperCommand.getParameter().setEditMode(CollectionController.this.isEditMode_);
            Application application = Yukinoshita.application();
            try {
                application.setCursorType(Application.CursorType.WAIT);
                wrapperCommand.execute();
            }
            finally {
                application.setCursorType(Application.CursorType.NONE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeCommand(ViewCommand viewCommand) {
            ArgumentChecker.throwIfNull((Object)viewCommand);
            ViewCommand.Parameter parameter = viewCommand.getParameter();
            if (parameter.isEditMode() == null) {
                parameter.setEditMode(CollectionController.this.isEditMode_);
            } else {
                CollectionController.this.isEditMode_ = parameter.isEditMode();
            }
            parameter.set(CollectionController.this);
            if (parameter.getCurrentStatus() == null && this.currentStatus_ != null) {
                parameter.setCurrentStatus(this.currentStatus_);
            }
            parameter.setIndexFilter(CollectionController.this.indexFilter_);
            Application application = Yukinoshita.application();
            try {
                application.setCursorType(Application.CursorType.WAIT);
                viewCommand.execute();
            }
            finally {
                application.setCursorType(Application.CursorType.NONE);
            }
            this.currentStatus_ = parameter.getCurrentStatus();
        }

        @Override
        public void update(CollectionProxy collectionProxy) {
            ArgumentChecker.throwIfNull((Object)collectionProxy);
            CollectionController.this.indexFilter_.clear();
            for (int i = 0; i < collectionProxy.size(); ++i) {
                CollectionController.this.indexFilter_.add(i);
            }
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
            ArgumentChecker.throwIfNull(list);
            CollectionController.this.indexFilter_.clear();
            CollectionController.this.indexFilter_.addAll(list);
        }
    }
}

