/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanListHandler;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

final class ScoreTable
extends AbstractTable {
    private static final Log log_s_ = LogFactory.getLog(ScoreTable.class);
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("USER", "VARCHAR", 0, "NOT NULL"), new HsqldbColumn("EXAMINED", "TIMESTAMP", 0, "NOT NULL"), new HsqldbColumn("RESULT", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("MOVES", "VARCHAR", 0, "NOT NULL"), new HsqldbColumn("PP", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("TIME_LIMIT", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("ELAPSED", "INTEGER", 0, "NOT NULL")};
    private static final ScoreTable instance_s_ = new ScoreTable();
    private static final ForeignKey[] foreignKeys_s_ = new ForeignKey[]{new ForeignKey("MASTER", "MASTER_ID", "SCORE", "MASTER_ID", 1)};

    static ScoreTable instance() {
        return instance_s_;
    }

    private ScoreTable() {
    }

    public boolean exists(DatabaseVersion databaseVersion) {
        return true;
    }

    public String getTable() {
        return "SCORE";
    }

    public PrimaryKey[] getPrimaryKeys(DatabaseVersion databaseVersion) {
        return new PrimaryKey[0];
    }

    public HsqldbColumn[] getColumns(DatabaseVersion databaseVersion) {
        return columns_s_;
    }

    protected ForeignKey[] getForeignKeys(DatabaseVersion databaseVersion) {
        return foreignKeys_s_;
    }

    protected String getInTableConstraints() {
        return "";
    }

    protected String[] getInterTableConstraintQueries() {
        return new String[]{"DELETE FROM score s WHERE s.master_id <> ALL ( SELECT m.master_id FROM master m );", "ALTER TABLE score ADD CONSTRAINT fk1_score FOREIGN KEY (master_id) REFERENCES master(master_id) ON DELETE CASCADE;"};
    }

    void insertScoreImpl(Connection connection, Score score) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO score (master_id, user, examined, result, moves, pp, time_limit, elapsed) VALUES(?, ?, CURRENT_TIMESTAMP, ?, ?, ?, ?, ?)", score.getMasterId(), score.getUser(), score.getResult(), score.getMoves(), score.getPp(), score.getTimeLimit(), score.getElapsed());
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        log_s_.log(LogLevel.TRACE, "INSERT: {1}" + score);
    }

    Score[] selectFromMaster(Connection connection, RootGameTree rootGameTree) throws SQLException {
        ArgumentChecker.throwIfNull((Object)connection, (Object)rootGameTree);
        QueryRunner queryRunner = new QueryRunner();
        List list = (List)((Object)queryRunner.query(connection, "SELECT s.master_id, s.user, s.examined, s.result, s.moves, s.pp, s.time_limit, s.elapsed FROM master m, score s WHERE m.master_id = s.master_id AND m.game_type = ? AND m.width = ? AND m.height = ? AND m.fingerprint = ? AND s.user = ? ORDER BY s.examined ASC", new Object[]{Integer.valueOf(rootGameTree.getGameType().getString()), rootGameTree.getSize().width(), rootGameTree.getSize().height(), Fingerprints.calcFingerprintArray(rootGameTree), Yukinoshita.USER_NAME}, new UBeanListHandler<Score>(Score.class)));
        return list.toArray(new Score[list.size()]);
    }

    int selectCount(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Number number = (Number)queryRunner.query(connection, "SELECT count('X') records FROM score WHERE user = ?", (Object)Yukinoshita.USER_NAME, new ScalarHandler());
        return number.intValue();
    }
}

