/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.unitarou.io.FileSnapshot;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sql.CheckerResult;
import org.unitarou.sql.CheckerResultType;
import org.unitarou.util.StopWatch;
import org.unitarou.util.TaskMonitor;
import org.unitarou.util.TaskRunnable;
import org.unitarou.util.Units;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.GameRecord;
import org.unitarou.yukinoshita.model.db.GameTerm;
import org.unitarou.yukinoshita.model.db.GameTermMap;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.DbServerHandler;
import org.unitarou.yukinoshita.model.db.hsql.FileIndexTable;
import org.unitarou.yukinoshita.model.db.hsql.FileSearchedView;
import org.unitarou.yukinoshita.model.db.hsql.GameIndexTable;
import org.unitarou.yukinoshita.model.db.hsql.GameRecordView;
import org.unitarou.yukinoshita.model.db.hsql.GameTermMapTable;
import org.unitarou.yukinoshita.model.db.hsql.MasterTable;
import org.unitarou.yukinoshita.model.db.hsql.ScoreTable;
import org.unitarou.yukinoshita.model.db.hsql.TermTable;
import org.unitarou.yukinoshita.model.db.hsql.UpdaterV1ToV2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDatabase
implements Database {
    private static final String CONNECTION_LOCAL_URL = "jdbc:hsqldb:file:./db/yukinoshita";
    private static final String CONNECTION_SERVER_URL = "jdbc:hsqldb:hsql://localhost:9001/yukinoshita";
    private static final Message NT_CONFIRM_UPGRADE = new Message(HsqlDatabase.class, "ntConfirmUpgrade");
    private static final Message MSG_CONFIRM_UPGRADE = new Message(HsqlDatabase.class, "msgConfirmGrade");
    private static final Message NT_UPGRADE = new Message(HsqlDatabase.class, "ntUpgrade");
    private static final Message LB_REBUILD_DATABASE = new Message(HsqlDatabase.class, "lbRebuildDatabase");
    private static final Message LB_OPTIMIZE_DATABASE = new Message(HsqlDatabase.class, "lbOptimizeDatabase");
    private static final Message LB_REBOOT_DATABASE = new Message(HsqlDatabase.class, "lbRebootDatabase");
    private static final Message NT_UPGRADE_FAILURE = new Message(HsqlDatabase.class, "ntUpgradeFailure");
    private static final Message MSG_UPGRADE_FAILURE = new Message(HsqlDatabase.class, "msgUpgradeFailure");
    private static final Message NT_FINISH_UPGRADE = new Message(HsqlDatabase.class, "ntFinishUpgrade");
    private static final Message MSG_FINISH_UPGRADE_V1_TO_V2 = new Message(HsqlDatabase.class, "msgFinishUpgradeV1ToV2");
    static final int COMPACT_THRESHOLD = 100;
    static final IntContextValue DELETE_RECORDS = new IntContextValue(HsqlDatabase.class, "deleteRecords", 0, 0, Integer.MAX_VALUE);
    private static final Log log_s_ = LogFactory.getLog(HsqlDatabase.class);
    private Connection connection_;

    public HsqlDatabase() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.log(LogLevel.WARN, "Failure class loading JDBC driver. Cause: {0}", classNotFoundException.getMessage());
        }
    }

    @Override
    public void setup() {
        this.connection_ = DbServerHandler.instance().setup(CONNECTION_SERVER_URL);
    }

    @Override
    public Exception getExceptionAtSetup() {
        return DbServerHandler.instance().getException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.connection_ != null) {
                this.close();
            }
        }
        finally {
            this.connection_ = null;
            super.finalize();
        }
    }

    @Override
    public void close() {
        DbServerHandler.instance().close();
    }

    @Override
    public boolean updateDatabase() {
        Enum enum_ = null;
        for (DatabaseVersion databaseVersion : DatabaseVersion.ALL_LIST) {
            CheckerResult checkerResult = this.selfCheck(databaseVersion);
            if (checkerResult.getTreeType() != CheckerResultType.MATCH) continue;
            enum_ = databaseVersion;
            break;
        }
        if (enum_ == null) {
            return false;
        }
        if (enum_ == DatabaseVersion.CURRENT) {
            return true;
        }
        switch (3.$SwitchMap$org$unitarou$yukinoshita$model$db$hsql$DatabaseVersion[enum_.ordinal()]) {
            case 1: {
                return this.updateV1ToV2();
            }
        }
        assert (false) : "Bad version: " + enum_;
        return this.updateDatabase();
    }

    private boolean updateV1ToV2() {
        Application application = Yukinoshita.application();
        if (!application.openMessageDialog(Application.MessageLevel.CONFIRM, NT_CONFIRM_UPGRADE.get(), MSG_CONFIRM_UPGRADE.get("1", "2"))) {
            return false;
        }
        StopWatch stopWatch = new StopWatch();
        final QueryRunner queryRunner = new QueryRunner();
        try {
            queryRunner.update(this.connection_, "SHUTDOWN");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection_ = DbServerHandler.instance().setup(CONNECTION_LOCAL_URL);
        final UpdaterV1ToV2 updaterV1ToV2 = new UpdaterV1ToV2();
        TaskRunnable taskRunnable = new TaskRunnable(){

            public void setTaskMonitor(TaskMonitor taskMonitor) {
                updaterV1ToV2.setMonitor(taskMonitor);
            }

            public void run() {
                updaterV1ToV2.update(HsqlDatabase.this.connection_);
            }
        };
        application.exec(NT_UPGRADE.get(), taskRunnable, true, false);
        if (updaterV1ToV2.getException() != null) {
            log_s_.log(LogLevel.WARN, updaterV1ToV2.getException(), "Failure of updateV1ToV2.");
            application.openMessageDialog(Application.MessageLevel.ERROR, NT_UPGRADE_FAILURE.get(), MSG_UPGRADE_FAILURE.get());
            return false;
        }
        taskRunnable = new TaskRunnable(){
            private TaskMonitor monitor_;

            public void setTaskMonitor(TaskMonitor taskMonitor) {
                this.monitor_ = taskMonitor;
            }

            public void run() {
                this.monitor_.start(2, LB_REBUILD_DATABASE.get());
                this.monitor_.subTaskStated(0, LB_OPTIMIZE_DATABASE.get(), -1);
                try {
                    queryRunner.update(HsqlDatabase.this.connection_, "SHUTDOWN COMPACT");
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.monitor_.subTaskStated(1, LB_REBOOT_DATABASE.get(), -1);
                HsqlDatabase.this.connection_ = DbServerHandler.instance().setup(HsqlDatabase.CONNECTION_SERVER_URL);
                this.monitor_.finished();
            }
        };
        application.exec(NT_UPGRADE.get(), taskRunnable, true, false);
        application.openMessageDialog(Application.MessageLevel.INFORMATION, NT_FINISH_UPGRADE.get(), MSG_FINISH_UPGRADE_V1_TO_V2.get((Object)Units.formatMSS(stopWatch.stop())));
        return true;
    }

    @Override
    public CheckerResult selfCheck() {
        return this.selfCheck(DatabaseVersion.CURRENT);
    }

    private CheckerResult selfCheck(DatabaseVersion databaseVersion) {
        CheckerResult checkerResult = new CheckerResult("", CheckerResultType.MATCH);
        if (this.connection_ == null) {
            return checkerResult;
        }
        ArrayList<CheckerResult> arrayList = new ArrayList<CheckerResult>();
        arrayList.add(MasterTable.instance().selfCheck(this.connection_, databaseVersion));
        arrayList.add(FileIndexTable.instance().selfCheck(this.connection_, databaseVersion));
        arrayList.add(GameIndexTable.instance().selfCheck(this.connection_, databaseVersion));
        arrayList.add(ScoreTable.instance().selfCheck(this.connection_, databaseVersion));
        arrayList.add(TermTable.instance().selfCheck(this.connection_, databaseVersion));
        arrayList.add(GameTermMapTable.instance().selfCheck(this.connection_, databaseVersion));
        for (CheckerResult checkerResult2 : arrayList) {
            checkerResult.addChild(checkerResult2);
        }
        return checkerResult;
    }

    @Override
    public void create() throws DatabaseException {
        DbServerHandler.instance().create();
    }

    @Override
    public Master selectMaster(RootGameTree rootGameTree) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (this.connection_ == null) {
            return null;
        }
        GameType gameType = rootGameTree.getGameType();
        SgfSize sgfSize = rootGameTree.getSize();
        try {
            return MasterTable.instance().selectFromUnique(this.connection_, rootGameTree, gameType, sgfSize);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public Master insertMaster(RootGameTree rootGameTree) throws DatabaseException {
        if (this.connection_ == null) {
            return new Master(rootGameTree);
        }
        try {
            ArgumentChecker.throwIfNull((Object)rootGameTree);
            Master master = MasterTable.instance().insert(this.connection_, rootGameTree);
            this.connection_.commit();
            Master master2 = master;
            return master2;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public FileIndex selectFileIndex(int n) throws DatabaseException {
        if (this.connection_ == null) {
            return null;
        }
        try {
            return FileIndexTable.instance().selectFromId(this.connection_, n);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private void updateTermMap(Set<String> set, GameTree gameTree, GameIndex gameIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : gameTree.getSequence()) {
            for (Property property : node.getProperties()) {
                String string;
                SgfId sgfId = property.sgfId();
                if (!this.isTargetTerm(sgfId, gameIndex) || (string = property.getString().trim()).length() == 0) continue;
                stringBuilder.setLength(0);
                stringBuilder.append(sgfId.id()).append(':').append(gameIndex.getGameType()).append(':').append(string);
                set.add(stringBuilder.toString());
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.updateTermMap(set, gameTree2, gameIndex);
        }
    }

    private boolean isTargetTerm(SgfId sgfId, GameIndex gameIndex) {
        return sgfId.equals(SgfId.DATE) && gameIndex.getDate() == null || sgfId.propertyType().equals(PropertyType.GAME_INFO) && !sgfId.equals(SgfId.DATE) && sgfId.cardinalityType().equals((Object)CardinalityType.SINGLE);
    }

    @Override
    public void refreshFileIndex(List<Collection> list) throws DatabaseException {
        Object object;
        Iterable<RootGameTree> iterable;
        ArgumentChecker.throwIfNull(list);
        if (this.connection_ == null) {
            return;
        }
        ArrayList<Collection> arrayList = new ArrayList<Collection>(list);
        ArrayList<FileSnapshot> arrayList2 = new ArrayList<FileSnapshot>(list.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iterable = (Collection)iterator.next();
            if (((Collection)iterable).size() == 0) {
                iterator.remove();
                continue;
            }
            object = ((Collection)iterable).getFileSnapshot();
            if (object == null || !Ios.isNormalFile(((FileSnapshot)object).file())) {
                iterator.remove();
                continue;
            }
            arrayList2.add((FileSnapshot)object);
        }
        assert (arrayList.size() == arrayList2.size());
        if (arrayList.isEmpty()) {
            return;
        }
        boolean bl = Yukinoshita.context(null).getAttribute(Database.FORCE_DB_UPDATE);
        try {
            Object object2;
            Object object3;
            Object object5;
            Iterable<RootGameTree> iterable2;
            if (!bl) {
                this.removeUnchangedTarget(arrayList, arrayList2);
                if (arrayList.isEmpty()) {
                    return;
                }
            }
            iterable = FileIndexTable.instance().refresh(this.connection_, arrayList2);
            object = new ArrayList(iterable.size());
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(iterable.size());
            ArrayList<RootGameTree> arrayList4 = new ArrayList<RootGameTree>(iterable.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                iterable2 = (Collection)arrayList.get(i);
                FileIndex fileIndex = (FileIndex)iterable.get(i);
                for (int j = 0; j < ((Collection)iterable2).size(); ++j) {
                    object5 = ((Collection)iterable2).get(j);
                    if (GameType.DRILL == ((RootGameTree)object5).getGameType()) continue;
                    arrayList4.add((RootGameTree)object5);
                    arrayList3.add(j);
                    object.add(fileIndex);
                }
            }
            List<Master> list2 = MasterTable.instance().insert(this.connection_, arrayList4);
            iterable2 = new ArrayList(list2.size());
            for (int i = 0; i < list2.size(); ++i) {
                GameIndex gameIndex = new GameIndex((RootGameTree)arrayList4.get(i));
                gameIndex.setFileId(((FileIndex)object.get(i)).getFileId());
                gameIndex.setFileOrder((Integer)arrayList3.get(i));
                gameIndex.setMasterId(list2.get(i).getMasterId());
                iterable2.add((GameIndex)gameIndex);
            }
            GameIndexTable.instance().refresh(this.connection_, (List<GameIndex>)iterable2);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < arrayList4.size(); ++i) {
                object5 = (RootGameTree)arrayList4.get(i);
                GameIndex object42 = (GameIndex)iterable2.get(i);
                this.updateTermMap(hashSet, (GameTree)object5, object42);
            }
            List<Term> list3 = new ArrayList<Term>(hashSet.size());
            for (String string : hashSet) {
                int n = string.indexOf(58);
                object3 = new Term();
                ((Term)object3).setSgfId(string.substring(0, n));
                object2 = string.substring(n + 1);
                n = ((String)object2).indexOf(58);
                ((Term)object3).setGameType(Integer.parseInt(((String)object2).substring(0, n)));
                ((Term)object3).setTerm(((String)object2).substring(n + 1));
                list3.add((Term)object3);
            }
            list3 = TermTable.instance().insertAndSelect(this.connection_, list3);
            object5 = new HashMap<Object, Integer>(list3.size());
            for (Term term : list3) {
                object3 = term.getSgfId() + ':' + term.getGameType() + ':' + term.getTerm();
                object5.put(object3, term.getTermId());
            }
            ArrayList<GameTermMap> arrayList5 = new ArrayList<GameTermMap>();
            for (int i = 0; i < arrayList4.size(); ++i) {
                object3 = new HashSet();
                object2 = (RootGameTree)arrayList4.get(i);
                GameIndex gameIndex = (GameIndex)iterable2.get(i);
                this.updateTermMap((Set<String>)object3, (GameTree)object2, gameIndex);
                Iterator iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    Integer n = (Integer)object5.get(string);
                    if (n == null) {
                        System.out.println();
                    }
                    assert (n != null);
                    GameTermMap gameTermMap = new GameTermMap();
                    gameTermMap.setTermId(n);
                    gameTermMap.setFileId(gameIndex.getFileId());
                    gameTermMap.setFileOrder(gameIndex.getFileOrder());
                    arrayList5.add(gameTermMap);
                }
            }
            GameTermMapTable.instance().update(this.connection_, arrayList5);
            this.connection_.commit();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    private void removeUnchangedTarget(List<Collection> list, List<FileSnapshot> list2) throws IOException, SQLException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(list2.size());
        for (FileSnapshot object2 : list2) {
            arrayList.add(object2.file().getCanonicalPath());
        }
        List<FileIndex> list3 = FileIndexTable.instance().selectFromPath(this.connection_, arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < arrayList.size(); ++n) {
            byte[] byArray;
            byte[] n2;
            if (list3.get(n) == null || !Arrays.equals(n2 = list2.get(n).getDigest(), byArray = ((FileIndex)list3.get(n)).getDigest())) continue;
            arrayList2.add(n);
        }
        for (n = arrayList2.size() - 1; 0 <= n; --n) {
            int n2 = (Integer)arrayList2.get(n);
            list.remove(n2);
            list2.remove(n2);
        }
        assert (list.size() == list2.size());
    }

    @Override
    public boolean deleteFileIndex(int n) throws DatabaseException {
        try {
            boolean bl = FileIndexTable.instance().delete(this.connection_, n);
            if (bl) {
                CurrentContext currentContext = Yukinoshita.context(null);
                int n2 = currentContext.getInteger(DELETE_RECORDS);
                currentContext.setInteger(DELETE_RECORDS.id(), ++n2);
            }
            this.connection_.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public boolean deleteAllFileIndices() throws DatabaseException {
        try {
            int n = FileIndexTable.instance().deleteAll(this.connection_);
            CurrentContext currentContext = Yukinoshita.context(null);
            int n2 = currentContext.getInteger(DELETE_RECORDS);
            currentContext.setInteger(DELETE_RECORDS.id(), n2 += n);
            this.connection_.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public int deleteNotFoundFileIndex() throws DatabaseException {
        try {
            int n = 0;
            FileIndex[] fileIndexArray = FileIndexTable.instance().select(this.connection_);
            for (FileIndex fileIndex : fileIndexArray) {
                File file = new File(fileIndex.getPath());
                if (Ios.isNormalFile(file)) continue;
                FileIndexTable.instance().delete(this.connection_, fileIndex.getFileId());
                ++n;
            }
            CurrentContext currentContext = Yukinoshita.context(null);
            int n2 = currentContext.getInteger(DELETE_RECORDS);
            currentContext.setInteger(DELETE_RECORDS.id(), n + n2);
            this.connection_.commit();
            int n3 = n;
            return n3;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public Score insertScore(RootGameTree rootGameTree, ProblemStatus problemStatus, ProblemProperties problemProperties, int n) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree, (Object)problemStatus, (Object)problemProperties);
        GameType gameType = rootGameTree.getGameType();
        if (gameType != GameType.PROBLEM || problemStatus.getId() == 0) {
            throw new IllegalArgumentException();
        }
        Score score = new Score(rootGameTree);
        if (this.connection_ == null) {
            return score;
        }
        try {
            Master master = MasterTable.instance().insert(this.connection_, rootGameTree);
            score.setMasterId(master.getMasterId());
            score.setResult(problemStatus.getId());
            score.setUser(Yukinoshita.USER_NAME);
            score.setPp(problemProperties.getIntValue());
            String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.TIMELIMIT);
            SgfNumber sgfNumber = SgfNumber.parseQuietly(string);
            if (sgfNumber != null) {
                score.setTimeLimit(sgfNumber.getIntValue());
            }
            score.setElapsed(n);
            ScoreTable.instance().insertScoreImpl(this.connection_, score);
            this.connection_.commit();
            Score score2 = score;
            return score2;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public Score[] selectScores(RootGameTree rootGameTree) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (this.connection_ == null) {
            return new Score[0];
        }
        try {
            return ScoreTable.instance().selectFromMaster(this.connection_, rootGameTree);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<SearchedFile> search(SearchFileCondition searchFileCondition) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)searchFileCondition);
        if (this.connection_ == null) {
            return Collections.emptyList();
        }
        try {
            return FileSearchedView.instance().select(this.connection_, searchFileCondition);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<TermFrequency> searchTermFrequency(SgfId sgfId, GameType gameType) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)sgfId);
        if (this.connection_ == null) {
            return Collections.emptyList();
        }
        try {
            return TermTable.instance().select(this.connection_, sgfId, gameType);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<GameTerm> selectGameTerm(GameType gameType, SgfId sgfId) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)sgfId);
        if (this.connection_ == null) {
            return Collections.emptyList();
        }
        try {
            return FileSearchedView.instance().selectGameTerm(this.connection_, gameType, sgfId);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<Term> search(GameIndex gameIndex) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)gameIndex);
        if (this.connection_ == null) {
            return Collections.emptyList();
        }
        try {
            return TermTable.instance().select(this.connection_, gameIndex);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public DatabaseStatistics selectStatistics() throws DatabaseException {
        DatabaseStatistics databaseStatistics = new DatabaseStatistics();
        if (this.connection_ == null) {
            return databaseStatistics;
        }
        try {
            databaseStatistics.setFileCount(FileIndexTable.instance().selectCount(this.connection_));
            QueryRunner queryRunner = new QueryRunner();
            List<Object[]> list = queryRunner.query(this.connection_, "SELECT m.game_type, COUNT('X') games FROM game_index g, master m WHERE g.master_id = m.master_id GROUP BY m.game_type ", new ArrayListHandler());
            block6: for (Object[] objectArray : list) {
                int n = ((Number)objectArray[1]).intValue();
                switch (((Number)objectArray[0]).intValue()) {
                    case 1: {
                        databaseStatistics.setGameCount(n);
                        continue block6;
                    }
                    case 3: {
                        databaseStatistics.setProblemCount(n);
                        continue block6;
                    }
                }
                log_s_.log(LogLevel.WARN, "[IGNORE] Unknown gametype {0}", objectArray[0]);
            }
            databaseStatistics.setScoreCount(ScoreTable.instance().selectCount(this.connection_));
            return databaseStatistics;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public Master selectMaster(int n) throws DatabaseException {
        if (this.connection_ == null) {
            return null;
        }
        try {
            return MasterTable.instance().selectFromPk(this.connection_, n);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<GameRecord> selectGameScore(String string, String string2) throws DatabaseException {
        if (this.connection_ == null) {
            return Collections.emptyList();
        }
        try {
            return GameRecordView.select(this.connection_, string, string2);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private void rollbackQuietly() {
        try {
            DbUtils.rollback(this.connection_);
        }
        catch (SQLException sQLException) {
            log_s_.log(LogLevel.WARN, sQLException, "Error occurred in rollback.");
        }
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$unitarou$yukinoshita$model$db$hsql$DatabaseVersion;

        static {
            $SwitchMap$org$unitarou$yukinoshita$model$db$hsql$DatabaseVersion = new int[DatabaseVersion.values().length];
            try {
                3.$SwitchMap$org$unitarou$yukinoshita$model$db$hsql$DatabaseVersion[DatabaseVersion.V_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

