/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.GameTermMap;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameTermMapTable
extends AbstractTable {
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("TERM_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FILE_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FILE_ORDER", "INTEGER", 0, "NOT NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("TERM_ID", 1), new PrimaryKey("FILE_ID", 2), new PrimaryKey("FILE_ORDER", 3)};
    private static final ForeignKey[] foreignKeys_s_ = new ForeignKey[]{new ForeignKey("GAME_INDEX", "FILE_ID", "GAME_TERM_MAP", "FILE_ID", 1), new ForeignKey("GAME_INDEX", "FILE_ORDER", "GAME_TERM_MAP", "FILE_ORDER", 2), new ForeignKey("TERM", "TERM_ID", "GAME_TERM_MAP", "TERM_ID", 1)};
    private static final GameTermMapTable instance_s_ = new GameTermMapTable();

    static GameTermMapTable instance() {
        return instance_s_;
    }

    private GameTermMapTable() {
    }

    @Override
    public boolean exists(DatabaseVersion databaseVersion) {
        return DatabaseVersion.V_2.getVersion() <= databaseVersion.getVersion();
    }

    @Override
    public String getTable() {
        return "GAME_TERM_MAP";
    }

    @Override
    protected PrimaryKey[] getPrimaryKeys(DatabaseVersion databaseVersion) {
        if (this.exists(databaseVersion)) {
            return primaryKey_s_;
        }
        return PrimaryKey.EMPTY_ARRAY;
    }

    @Override
    protected HsqldbColumn[] getColumns(DatabaseVersion databaseVersion) {
        if (this.exists(databaseVersion)) {
            return columns_s_;
        }
        return HsqldbColumn.EMPTY_ARRAY;
    }

    @Override
    protected ForeignKey[] getForeignKeys(DatabaseVersion databaseVersion) {
        if (this.exists(databaseVersion)) {
            return foreignKeys_s_;
        }
        return ForeignKey.EMPTY_ARRAY;
    }

    @Override
    protected String getInTableConstraints() {
        return "";
    }

    @Override
    protected String[] getInterTableConstraintQueries() {
        return new String[]{"ALTER TABLE game_term_map ADD CONSTRAINT fk1_game_term_map FOREIGN KEY (file_id, file_order) REFERENCES game_index(file_id, file_order) ON DELETE CASCADE", "ALTER TABLE game_term_map ADD CONSTRAINT fk2_game_term_map FOREIGN KEY (term_id) REFERENCES term(term_id) ON DELETE CASCADE"};
    }

    void update(Connection connection, GameIndex gameIndex, List<Term> list) throws SQLException {
        UQueryRunner uQueryRunner = new UQueryRunner();
        Integer n = gameIndex.getFileId();
        Integer n2 = gameIndex.getFileOrder();
        uQueryRunner.update(connection, "DELETE FROM game_term_map WHERE file_id = ? AND file_order = ?", n, n2);
        Object[][] objectArray = new Object[list.size()][];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new Object[]{n, n2, list.get(i).getTermId()};
        }
        uQueryRunner.batch(connection, "INSERT INTO game_term_map (file_id, file_order, term_id) VALUES(?, ?, ?)", objectArray);
    }

    void update(Connection connection, List<GameTermMap> list) throws SQLException {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(list.size());
        HashSet<String> hashSet = new HashSet<String>();
        for (GameTermMap objectArray2 : list) {
            String i = String.valueOf(objectArray2.getFileId()) + ':' + String.valueOf(objectArray2.getFileOrder());
            if (hashSet.contains(i)) continue;
            hashSet.add(i);
            arrayList.add(new Object[]{objectArray2.getFileId(), objectArray2.getFileOrder()});
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        uQueryRunner.batch(connection, "DELETE FROM game_term_map WHERE file_id = ? AND file_order = ?", (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]));
        Object[][] objectArray = new Object[list.size()][3];
        for (int i = 0; i < objectArray.length; ++i) {
            GameTermMap gameTermMap = list.get(i);
            objectArray[i][0] = gameTermMap.getFileId();
            objectArray[i][1] = gameTermMap.getFileOrder();
            objectArray[i][2] = gameTermMap.getTermId();
        }
        uQueryRunner.batch(connection, "INSERT INTO game_term_map (file_id, file_order, term_id) VALUES(?, ?, ?)", objectArray);
    }
}

