/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.unitarou.io.FileSnapshot;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanHandler;
import org.unitarou.sql.UBeanListHandler;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileIndexTable
extends AbstractTable {
    private static final Log log_s_ = LogFactory.getLog(FileIndexTable.class);
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("FILE_ID", "INTEGER", 0, "NOT NULL", true), new HsqldbColumn("PATH", "VARCHAR", 0, "NOT NULL"), new HsqldbColumn("DIGEST", "VARBINARY", 16, "NOT NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("FILE_ID", 1)};
    private static final ForeignKey[] foreignKeys_s_ = new ForeignKey[0];
    private static final FileIndexTable instance_s_ = new FileIndexTable();

    static FileIndexTable instance() {
        return instance_s_;
    }

    private FileIndexTable() {
    }

    @Override
    public boolean exists(DatabaseVersion databaseVersion) {
        return true;
    }

    @Override
    public String getTable() {
        return "FILE_INDEX";
    }

    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseVersion databaseVersion) {
        return primaryKey_s_;
    }

    @Override
    public HsqldbColumn[] getColumns(DatabaseVersion databaseVersion) {
        return columns_s_;
    }

    @Override
    protected ForeignKey[] getForeignKeys(DatabaseVersion databaseVersion) {
        return foreignKeys_s_;
    }

    @Override
    protected String getInTableConstraints() {
        return "CONSTRAINT uq1_file_index UNIQUE (path)";
    }

    @Override
    protected String[] getInterTableConstraintQueries() {
        return new String[0];
    }

    FileIndex[] select(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        List list = (List)((Object)queryRunner.query(connection, "SELECT file_id, path, digest FROM file_index", new UBeanListHandler<FileIndex>(FileIndex.class)));
        FileIndex[] fileIndexArray = new FileIndex[list.size()];
        for (int i = 0; i < fileIndexArray.length; ++i) {
            fileIndexArray[i] = (FileIndex)list.get(i);
        }
        return fileIndexArray;
    }

    public FileIndex selectFromId(Connection connection, int n) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        FileIndex fileIndex = (FileIndex)queryRunner.query(connection, "SELECT file_id, path, digest FROM file_index WHERE file_id=?", (Object)n, new UBeanHandler(FileIndex.class));
        return fileIndex;
    }

    FileIndex selectFromPath(Connection connection, String string) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        FileIndex fileIndex = (FileIndex)queryRunner.query(connection, "SELECT file_id, path, digest FROM file_index WHERE path=?", (Object)string, new UBeanHandler(FileIndex.class));
        return fileIndex;
    }

    List<FileIndex> selectFromPath(Connection connection, List<String> list) throws SQLException {
        Object[][] objectArray = new Object[list.size()][1];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i][0] = list.get(i);
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        List<FileIndex> list2 = uQueryRunner.queryOneRecord(connection, "SELECT file_id, path, digest FROM file_index WHERE path=?", objectArray, FileIndex.class);
        return list2;
    }

    List<FileIndex> refresh(Connection connection, List<FileSnapshot> list) throws IOException, SQLException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (FileSnapshot object2 : list) {
            arrayList.add(object2.file().getCanonicalPath());
        }
        List<FileIndex> list2 = this.selectFromPath(connection, arrayList);
        ArrayList<FileIndex> arrayList2 = new ArrayList<FileIndex>(list2.size());
        ArrayList<FileIndex> arrayList3 = new ArrayList<FileIndex>(list2.size());
        for (int i = 0; i < list.size(); ++i) {
            FileIndex fileIndex = (FileIndex)list2.get(i);
            if (fileIndex == null) {
                FileIndex fileIndex2 = new FileIndex();
                fileIndex2.setPath((String)arrayList.get(i));
                fileIndex2.setDigest(list.get(i).getDigest());
                arrayList2.add(fileIndex2);
                continue;
            }
            fileIndex.setDigest(list.get(i).getDigest());
            arrayList3.add(fileIndex);
        }
        this.update(connection, arrayList3);
        this.insert(connection, arrayList2);
        return this.selectFromPath(connection, arrayList);
    }

    private void update(Connection connection, List<FileIndex> list) throws SQLException {
        Object object;
        Object[][] objectArray = new Object[list.size()][3];
        for (int i = 0; i < objectArray.length; ++i) {
            object = list.get(i);
            objectArray[i][0] = ((FileIndex)object).getPath();
            objectArray[i][1] = ((FileIndex)object).getDigest();
            objectArray[i][2] = ((FileIndex)object).getFileId();
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        for (Object object2 : object = (Object)uQueryRunner.batch(connection, "UPDATE file_index SET path=?, digest=? WHERE file_id=?", objectArray)) {
            if (object2 == true) continue;
            throw new SQLException("DB is broken: update error record:" + (int)object2);
        }
    }

    private void insert(Connection connection, List<FileIndex> list) throws SQLException {
        Object object;
        Object[][] objectArray = new Object[list.size()][2];
        for (int i = 0; i < objectArray.length; ++i) {
            object = list.get(i);
            objectArray[i][0] = ((FileIndex)object).getPath();
            objectArray[i][1] = ((FileIndex)object).getDigest();
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        for (Object object2 : object = (Object)uQueryRunner.batch(connection, "INSERT INTO file_index (file_id, path, digest) VALUES(null, ?, ?)", objectArray)) {
            if (object2 == true) continue;
            throw new SQLException("DB is broken: insert error record:" + (int)object2);
        }
    }

    boolean delete(Connection connection, int n) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n2 = queryRunner.update(connection, "DELETE FROM file_index WHERE file_id = ? ", new Object[]{n});
        if (1 < n2) {
            throw new SQLException("DB is broken: delete error record:" + n2);
        }
        log_s_.log(LogLevel.TRACE, "DELETE: fileId={0}", n);
        return n2 == 1;
    }

    int deleteAll(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "DELETE FROM file_index");
        log_s_.log(LogLevel.TRACE, "DELETE ALL: {0} records.", n);
        return n;
    }

    int selectCount(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Number number = (Number)queryRunner.query(connection, "SELECT count('X') records FROM file_index", new ScalarHandler());
        return number.intValue();
    }
}

