/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoneGroupImpl {
    private final SgfSize size_;
    private final Set<SgfPoint> stones_;
    private final Set<SgfPoint> neighbors_;
    private final Set<SgfPoint> lifePoints_;

    StoneGroupImpl(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        assert (sgfSize != null);
        this.size_ = sgfSize;
        this.stones_ = new HashSet<SgfPoint>();
        this.neighbors_ = new HashSet<SgfPoint>();
        this.lifePoints_ = new HashSet<SgfPoint>();
    }

    StoneGroupImpl(StoneGroupImpl stoneGroupImpl) {
        ArgumentChecker.throwIfNull((Object)stoneGroupImpl);
        this.size_ = stoneGroupImpl.size_;
        this.stones_ = new HashSet<SgfPoint>(stoneGroupImpl.stones_);
        this.neighbors_ = new HashSet<SgfPoint>(stoneGroupImpl.neighbors_);
        this.lifePoints_ = new HashSet<SgfPoint>(stoneGroupImpl.lifePoints_);
    }

    boolean add(SgfPoint sgfPoint, Collection<SgfPoint> collection) {
        ArgumentChecker.throwIfNull((Object)sgfPoint, collection);
        if (!this.size_.equals(sgfPoint.size())) {
            throw new IllegalArgumentException("Bad size " + this.size_ + "!=" + sgfPoint.size());
        }
        if (!this.lifePoints_.contains(sgfPoint) && !this.lifePoints_.isEmpty()) {
            return false;
        }
        this.stones_.add(sgfPoint);
        for (SgfPoint sgfPoint2 : sgfPoint.neighbors()) {
            if (this.stones_.contains(sgfPoint2)) continue;
            this.neighbors_.add(sgfPoint2);
        }
        this.lifePoints_.remove(sgfPoint);
        for (SgfPoint sgfPoint2 : collection) {
            if (this.stones_.contains(sgfPoint2)) {
                throw new IllegalArgumentException(sgfPoint2 + " does not touch this group" + BasicFormatter.format(this.stones_));
            }
            this.lifePoints_.add(sgfPoint2);
        }
        return true;
    }

    void add(StoneGroupImpl stoneGroupImpl) {
        ArgumentChecker.throwIfNull((Object)stoneGroupImpl);
        this.stones_.addAll(stoneGroupImpl.stones_);
        this.neighbors_.addAll(stoneGroupImpl.neighbors_);
        this.lifePoints_.addAll(stoneGroupImpl.lifePoints_);
        this.lifePoints_.removeAll(this.stones_);
    }

    StoneGroupImpl[] remove(SgfPoint sgfPoint) {
        assert (sgfPoint != null && this.stones_.contains(sgfPoint));
        this.stones_.remove(sgfPoint);
        this.lifePoints_.add(sgfPoint);
        for (SgfPoint object : sgfPoint.neighbors()) {
            if (!this.lifePoints_.contains(object)) continue;
            boolean bl = true;
            for (SgfPoint sgfPoint2 : object.neighbors()) {
                if (!this.stones_.contains(sgfPoint2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.lifePoints_.remove(object);
        }
        this.neighbors_.clear();
        for (SgfPoint sgfPoint3 : this.stones_) {
            this.neighbors_.addAll(sgfPoint3.neighbors());
        }
        HashSet hashSet = new HashSet();
        for (SgfPoint sgfPoint4 : this.stones_) {
            boolean bl = false;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                StoneGroupImpl stoneGroupImpl = (StoneGroupImpl)iterator.next();
                if (!stoneGroupImpl.stones_.contains(sgfPoint4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            StoneGroupImpl stoneGroupImpl = new StoneGroupImpl(this.size_);
            stoneGroupImpl.trace(sgfPoint4, this);
            hashSet.add(stoneGroupImpl);
        }
        if (hashSet.isEmpty()) {
            this.neighbors_.clear();
            this.lifePoints_.clear();
            hashSet.add(this);
        }
        return hashSet.toArray(new StoneGroupImpl[hashSet.size()]);
    }

    private void trace(SgfPoint sgfPoint, StoneGroupImpl stoneGroupImpl) {
        this.stones_.add(sgfPoint);
        for (SgfPoint sgfPoint2 : sgfPoint.neighbors()) {
            if (stoneGroupImpl.lifePoints_.contains(sgfPoint2)) {
                this.lifePoints_.add(sgfPoint2);
            }
            if (this.stones_.contains(sgfPoint2)) continue;
            this.neighbors_.add(sgfPoint2);
            if (!stoneGroupImpl.stones_.contains(sgfPoint2)) continue;
            this.trace(sgfPoint2, stoneGroupImpl);
        }
    }

    void addLifePoint(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        this.lifePoints_.add(sgfPoint);
    }

    boolean removeLifePoint(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        assert (sgfPoint != null);
        if (this.lifePoints_.remove(sgfPoint)) {
            return this.lifePoints_.isEmpty();
        }
        return false;
    }

    Set<SgfPoint> stones() {
        return Collections.unmodifiableSet(this.stones_);
    }

    int count() {
        return this.stones_.size();
    }

    int countLifePoint() {
        return this.lifePoints_.size();
    }

    boolean contains(SgfPoint sgfPoint) {
        return this.stones_.contains(sgfPoint);
    }

    boolean isNeighbor(SgfPoint sgfPoint) {
        return this.neighbors_.contains(sgfPoint);
    }

    boolean isLifePoint(SgfPoint sgfPoint) {
        return this.lifePoints_.contains(sgfPoint);
    }
}

