/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Runtimes;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.HandlerSelector;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.view.cmd.ViewCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBrokerImpl
implements EventBroker {
    private static final Log log_s_ = LogFactory.getLog(EventBrokerImpl.class);
    private static final Class<?>[] viewAdapters_s_ = new Class[]{CollectionMonitor.class, GameMonitor.class, NodeListMonitor.class, NodeMonitor.class, GameInfoNodeMonitor.class, ControllerStatusMonitor.class, ProblemStatusMonitor.class, OutlineMonitor.class, LayoutMonitor.class, CommandDriverMonitor.class, MouseWheelMonitor.class};
    private static final Class<?>[] ctrlAdapters_s_ = new Class[]{ActionListener.class};
    private final Map<Class<?>, Set<Object>> adapterMap_ = new HashMap();
    private final HandlerSelector handlerSelector_ = new HandlerSelector();

    public EventBrokerImpl() {
        this.handlerSelector_.setEventBroker(this);
    }

    public void dispose() {
        for (Set<Object> set : this.adapterMap_.values()) {
            set.clear();
        }
        this.adapterMap_.clear();
        this.handlerSelector_.clear();
    }

    @Override
    public void addView(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class<?> clazz : viewAdapters_s_) {
            this.addAdapter(adaptable, clazz);
        }
    }

    @Override
    public void removeView(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class<?> clazz : viewAdapters_s_) {
            this.removeAdapter(adaptable, clazz);
        }
    }

    public void addController(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class<?> clazz : ctrlAdapters_s_) {
            this.addAdapter(adaptable, clazz);
        }
    }

    public void removeController(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class<?> clazz : ctrlAdapters_s_) {
            this.removeAdapter(adaptable, clazz);
        }
    }

    private void addAdapter(Adaptable adaptable, Class<?> clazz) {
        Object object;
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new LinkedHashSet<Object>();
            this.adapterMap_.put(clazz, set);
        }
        if ((object = adaptable.getAdapter(clazz)) == null) {
            return;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + object);
        }
        set.add(object);
        log_s_.log(LogLevel.TRACE, "[ADD ADAPTER] {0} has {1}''s adapter: {2}", Classes.simpleName(adaptable.getClass()), Classes.simpleName(clazz), object);
    }

    private void removeAdapter(Adaptable adaptable, Class<?> clazz) {
        Object object = adaptable.getAdapter(clazz);
        if (object == null) {
            return;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + object);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set != null) {
            set.remove(object);
        }
        log_s_.log(LogLevel.TRACE, "[DEL ADAPTER] {0} has {1}''s adapter: {2}", Classes.simpleName(adaptable.getClass()), Classes.simpleName(clazz), object);
    }

    @Override
    public <T> List<T> getListeners(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new LinkedHashSet<Object>();
            log_s_.log(LogLevel.WARN, "Unused or unregistered listener (May be BUG): {0}", clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        for (Object object : set) {
            arrayList.add(object);
        }
        log_s_.log(LogLevel.TRACE, "[CALL LISTENER] {0} is called. Listener size is {1}", clazz.getName(), arrayList.size());
        return arrayList;
    }

    @Override
    public void register(GameType gameType, boolean bl, StateHandler stateHandler) {
        this.handlerSelector_.put(gameType, bl, stateHandler);
        stateHandler.setEventBroker(this);
        log_s_.log(LogLevel.TRACE, "[REGISTER] {0} (Edit mode:{1}), state handler: {2}", gameType, bl, stateHandler);
    }

    @Override
    public void connect(GameType gameType, boolean bl) {
        this.handlerSelector_.connect(gameType, bl);
        log_s_.log(LogLevel.TRACE, "[CONNECT] {0}/Edit mode: {1}", gameType, bl);
    }

    @Override
    public void disconnect() {
        this.handlerSelector_.disconnect();
        log_s_.log(LogLevel.TRACE, "[DISCONNECT]");
    }

    @Override
    public StateHandler getCurrentStateHander() {
        return this.handlerSelector_.getCurrent();
    }

    @Override
    public void executeCommand(NodeListCommand nodeListCommand) {
        ArgumentChecker.throwIfNull((Object)nodeListCommand);
        log_s_.log(LogLevel.TRACE, "[START COMMAND] {0} {1}", nodeListCommand, Runtimes.formatStackTrace(4));
        for (CommandDriverMonitor eventListener : this.getListeners(CommandDriverMonitor.class)) {
            eventListener.justBeforeExecution(nodeListCommand);
        }
        for (ActionListener actionListener : this.getListeners(ActionListener.class)) {
            actionListener.executeCommand(nodeListCommand);
        }
        log_s_.log(LogLevel.TRACE, "[END COMMAND] {0}", nodeListCommand);
    }

    @Override
    public void executeCommand(ViewCommand viewCommand) {
        ArgumentChecker.throwIfNull((Object)viewCommand);
        log_s_.log(LogLevel.TRACE, "[START COMMAND] {0} {1}", viewCommand, Runtimes.formatStackTrace(4));
        for (CommandDriverMonitor eventListener : this.getListeners(CommandDriverMonitor.class)) {
            eventListener.justBeforeExecution(viewCommand);
        }
        for (ActionListener actionListener : this.getListeners(ActionListener.class)) {
            actionListener.executeCommand(viewCommand);
        }
        log_s_.log(LogLevel.TRACE, "[END COMMAND] {0}", viewCommand);
    }
}

