/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitarou.lang.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrategyRegistrar {
    private final Map<Class<?>, List<Class<?>>> registerMap_ = new HashMap();

    public boolean registerStrategy(Class<?> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        List<Class<?>> list = this.registerMap_.get(clazz);
        if (list == null) {
            list = new ArrayList();
            this.registerMap_.put(clazz, list);
            return true;
        }
        return false;
    }

    public Class<?>[] registerConcreteStrategy(Class<?> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<Class<?>, List<Class<?>>> entry : this.registerMap_.entrySet()) {
            Class<?> clazz2 = entry.getKey();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            List<Class<?>> list = entry.getValue();
            list.add(clazz);
            arrayList.add(clazz2);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public void clear() {
        this.registerMap_.clear();
    }

    public Class<?>[] getStrategies() {
        return this.registerMap_.keySet().toArray(new Class[this.registerMap_.size()]);
    }

    public <T> Class<T>[] getConcreteStrategies(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Class[] classArray = (Class[])Array.newInstance(clazz.getClass(), 0);
        List<Class<?>> list = this.registerMap_.get(clazz);
        if (list == null) {
            return classArray;
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (Class<?> clazz2 : list) {
            arrayList.add(clazz2);
        }
        return arrayList.toArray(classArray);
    }

    public <T> T[] getConcreteStrategyInstances(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
        List<Class<?>> list = this.registerMap_.get(clazz);
        if (list == null) {
            return objectArray;
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (Class<?> clazz2 : list) {
            try {
                arrayList.add(clazz2.newInstance());
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return arrayList.toArray(objectArray);
    }
}

