/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.lang.reflect.Array;
import org.eclipse.core.runtime.Assert;
import org.unitarou.lang.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<E> {
    private final Class<E> clazz_;
    private int capacity_;
    private int size_;
    private E[] listeners = null;

    public ListenerList(Class<E> clazz) {
        this(clazz, 1);
    }

    public ListenerList(Class<E> clazz, int n) {
        ArgumentChecker.throwIfNull(clazz);
        Assert.isTrue(n >= 1);
        this.capacity_ = n;
        this.clazz_ = clazz;
    }

    public void add(E e) {
        Assert.isNotNull(e);
        if (this.size_ == 0) {
            this.listeners = (Object[])Array.newInstance(e.getClass(), this.capacity_);
        } else {
            for (int i = 0; i < this.size_; ++i) {
                if (this.listeners[i] != e) continue;
                return;
            }
            if (this.size_ == this.listeners.length) {
                this.listeners = (Object[])Array.newInstance(e.getClass(), this.size_ * 2 + 1);
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size_);
            }
        }
        this.listeners[this.size_] = e;
        ++this.size_;
    }

    public void clear() {
        this.size_ = 0;
        this.listeners = null;
    }

    public E[] getListeners() {
        if (this.size_ == 0) {
            return (Object[])Array.newInstance(this.clazz_, 0);
        }
        Object[] objectArray = (Object[])Array.newInstance(this.listeners.getClass().getComponentType(), this.size_);
        System.arraycopy(this.listeners, 0, objectArray, 0, this.size_);
        return objectArray;
    }

    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public void remove(E e) {
        Assert.isNotNull(e);
        for (int i = 0; i < this.size_; ++i) {
            if (this.listeners[i] != e) continue;
            if (this.size_ == 1) {
                this.listeners = null;
                this.size_ = 0;
            } else {
                System.arraycopy(this.listeners, i + 1, this.listeners, i, --this.size_ - i);
                this.listeners[this.size_] = null;
            }
            return;
        }
    }

    public int size() {
        return this.size_;
    }
}

