/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.unitarou.lang.ArgumentChecker;

public class Line {
    private final Point s_;
    private final Point e_;

    public Line(Point point, Point point2) {
        ArgumentChecker.throwIfNull((Object)point, (Object)point2);
        if (point.equals((Object)point2)) {
            throw new IllegalArgumentException();
        }
        if (point.x < point2.x) {
            this.s_ = new Point(point.x, point.y);
            this.e_ = new Point(point2.x, point2.y);
        } else {
            this.s_ = new Point(point2.x, point2.y);
            this.e_ = new Point(point.x, point.y);
        }
    }

    public double distance(Point point) {
        ArgumentChecker.throwIfNull((Object)point);
        if (this.e_.x == this.s_.x && Math.min(this.s_.y, this.e_.y) < point.y && point.y < Math.max(this.s_.y, this.e_.y)) {
            return Math.abs(this.s_.x - point.x);
        }
        if (this.e_.y == this.s_.y && this.s_.x < point.x && point.x < this.e_.x) {
            return Math.abs(this.s_.y - point.y);
        }
        if (point.x < this.s_.x) {
            return Math.sqrt(Geometry.distanceSquared(point, this.s_));
        }
        if (this.e_.x < point.x) {
            return Math.sqrt(Geometry.distanceSquared(point, this.e_));
        }
        double d = this.e_.x - this.s_.x;
        double d2 = this.e_.y - this.s_.y;
        double d3 = d * d;
        double d4 = d2 * d2;
        return Math.abs(Math.sqrt(d4 + d3) / (d4 + d3) * (d2 * (double)(this.s_.x - point.x) - d * (double)(this.s_.y - point.y)));
    }
}

