/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.pc;

import java.util.EnumSet;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.pc.BaribariKids;
import org.unitarou.sgf.util.pc.Goproblems;
import org.unitarou.sgf.util.pc.NormalRecord;
import org.unitarou.sgf.util.pc.ProblemConverter;
import org.unitarou.sgf.util.pc.UliGo;
import org.unitarou.sgf.util.pc.YukinoshitaProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProblemType {
    GOPROBLEMS(new Goproblems()),
    ULIGO(new UliGo()),
    BARIBARI(new BaribariKids()),
    YUKINOSHITA(new YukinoshitaProblem()),
    NORMAL(new NormalRecord());

    private final ProblemConverter converter_;

    public static EnumSet<ProblemType> analyze(RootGameTree rootGameTree) {
        EnumSet<ProblemType> enumSet = EnumSet.noneOf(ProblemType.class);
        switch (rootGameTree.getGameType()) {
            case PROBLEM: {
                if (null == BasicFinder.firstMove(rootGameTree)) break;
                enumSet.add(YUKINOSHITA);
                break;
            }
            case DRILL: {
                return enumSet;
            }
        }
        if (ProblemType.GOPROBLEMS.converter_.isSatisfied(rootGameTree)) {
            enumSet.add(GOPROBLEMS);
        }
        if (ProblemType.ULIGO.converter_.isSatisfied(rootGameTree)) {
            enumSet.add(ULIGO);
        }
        if (ProblemType.BARIBARI.converter_.isSatisfied(rootGameTree)) {
            enumSet.add(BARIBARI);
        }
        if (enumSet.isEmpty()) {
            enumSet.add(NORMAL);
        }
        return enumSet;
    }

    private ProblemType(ProblemConverter problemConverter) {
        this.converter_ = problemConverter;
    }

    public ProblemConverter getConverter() {
        return this.converter_;
    }

    public boolean isAppendable(EnumSet<ProblemType> enumSet) {
        return !(this.equals((Object)BARIBARI) && enumSet.contains((Object)GOPROBLEMS) || this.equals((Object)GOPROBLEMS) && enumSet.contains((Object)BARIBARI) || this.equals((Object)ULIGO));
    }

    public String toString() {
        Messages messages = Messages.createByPackage(((Object)((Object)this)).getClass());
        return messages.get(Messages.createKey(((Object)((Object)this)).getClass(), this.name()));
    }
}

