/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.filter.RotationMirrorFilter;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotationMirrorFilters {
    public static void doFilter(RootGameTree rootGameTree, RotationMirrorFilter rotationMirrorFilter) throws FilterException {
        ArgumentChecker.throwIfNull((Object)rootGameTree, (Object)rotationMirrorFilter);
        RotationMirrorFilters.doFilterImpl(rootGameTree, rootGameTree.getSize(), rotationMirrorFilter.getFilter());
    }

    private static void doFilterImpl(GameTree gameTree, SgfSize sgfSize, Filter<SgfPoint> filter) throws FilterException {
        for (Node node : gameTree.getSequence()) {
            for (Property property : node.getProperties()) {
                node.removeProperty(property.sgfId());
                node.addProperty(RotationMirrorFilters.doFilterImpl(property, sgfSize, filter));
            }
        }
        for (int i = 0; i < gameTree.getChildrenSize(); ++i) {
            RotationMirrorFilters.doFilterImpl(gameTree.getChild(i), sgfSize, filter);
        }
    }

    private static Property doFilterImpl(Property property, SgfSize sgfSize, Filter<SgfPoint> filter) throws FilterException {
        ValueType valueType = property.sgfId().valueType();
        if (valueType.equals((Object)ValueType.MOVE) || valueType.equals((Object)ValueType.POINT) || valueType.equals((Object)ValueType.CPOINT)) {
            String[] stringArray = property.getStrings();
            SgfPoint[] sgfPointArray = SgfPoint.parse(sgfSize, stringArray);
            Property property2 = new Property();
            property2.setId(property.getId());
            for (int i = 0; i < sgfPointArray.length; ++i) {
                sgfPointArray[i] = filter.filter(sgfPointArray[i]);
            }
            SgfRectangle[] sgfRectangleArray = SgfRectangle.createRegularRectangles(sgfPointArray);
            if (sgfRectangleArray.length == 0) {
                for (SgfPoint sgfPoint : sgfPointArray) {
                    property2.addValue(new Value(sgfPoint.getString()));
                }
            } else {
                for (SgfRectangle sgfRectangle : sgfRectangleArray) {
                    property2.addValue(new Value(sgfRectangle.getValue()));
                }
            }
            return property2;
        }
        if (property.sgfId().equals(SgfId.LABEL)) {
            Property property3 = new Property();
            property3.setId(property.getId());
            String[] stringArray = property.getStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                Label label = Label.parseQuietly(sgfSize, stringArray[i]);
                if (label == null) continue;
                label = new Label(filter.filter(label.getPoint()), label.getLabel());
                property3.addValue(new Value(label.getString()));
            }
            return property3;
        }
        return property;
    }
}

