/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.filter.ReflectionFilter;
import org.unitarou.sgf.util.filter.Rotate180Filter;
import org.unitarou.sgf.util.filter.Rotate270Filter;
import org.unitarou.sgf.util.filter.Rotate90Filter;
import org.unitarou.util.NullFilter;
import org.unitarou.util.ReversibleFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RotationMirrorFilter {
    NO_ROTATION_NO_MIRROR(new NullFilter<SgfPoint>()),
    CLOCKWISE_90_ROTATION(new Rotate90Filter()),
    CLOCKWISE_180_ROTATION(new Rotate180Filter()),
    CLOCKWISE_270_ROTATION(new Rotate270Filter()),
    BR_DIAGONAL_MIRROR(new ReflectionFilter()),
    HORIZONTAL_MIRROR(new Rotate90Filter(new ReflectionFilter())),
    VERTICAL_MIRROR(new Rotate180Filter(new ReflectionFilter())),
    UR_DIAGONAL_MIRROR(new Rotate270Filter(new ReflectionFilter()));

    private final ReversibleFilter<SgfPoint> filter_;

    private RotationMirrorFilter(ReversibleFilter<SgfPoint> reversibleFilter) {
        this.filter_ = reversibleFilter;
    }

    public ReversibleFilter<SgfPoint> getFilter() {
        return this.filter_;
    }

    public SgfPoint filter(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.filter_.filter(sgfPoint);
    }

    public SgfPoint reverse(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.filter_.reverse(sgfPoint);
    }
}

